% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{Idom.numCSup.bnd.tri}
\alias{Idom.numCSup.bnd.tri}
\title{Indicator for an upper bound for the domination number of Central Similarity Proximity Catch Digraph
(CS-PCD) by the exact algorithm - one triangle case}
\usage{
Idom.numCSup.bnd.tri(Xp, k, tri, t, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of CS-PCD.}

\item{k}{A positive integer to be tested for an upper bound for the domination number of CS-PCDs.}

\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region in the
triangle \code{tri}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates which serves as a
center in the interior of the triangle \code{tri}; default is \eqn{M=(1,1,1)}, i.e.
the center of mass of \code{tri}.}
}
\value{
A \code{list} with two elements
\item{domUB}{The upper bound \code{k} (to be checked) for the domination number of CS-PCD. It is prespecified
as \code{k} in the function arguments.}
\item{Idom.num.up.bnd}{The indicator for the upper bound for domination number of CS-PCD being the
specified value \code{k} or not. It returns 1 if the upper bound is \code{k}, and 0 otherwise.}
\item{ind.domset}{The vertices (i.e., data points) in the dominating set of size \code{k} if it exists,
otherwise it is \code{NULL}.}
}
\description{
Returns \eqn{I(}domination number of CS-PCD is less than or equal to \code{k}\eqn{)} where the vertices of the CS-PCD are the data points \code{Xp},
that is, returns 1 if the domination number of CS-PCD is less than the prespecified value \code{k}, returns 0
otherwise. It also provides the vertices (i.e., data points) in a dominating set of size \code{k} of CS-PCD.

CS proximity region is constructed with respect to the triangle \code{tri}\eqn{=T(A,B,C)} with
expansion parameter \eqn{t>0} and edge regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \code{tri};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \code{tri}.

Edges of \code{tri}, \eqn{AB}, \eqn{BC}, \eqn{AC}, are also labeled as 3, 1, and 2, respectively.
Loops are allowed in the digraph.

See also (\insertCite{ceyhan:mcap2012;textual}{pcds}).

Caveat: It takes a long time for large number of vertices (i.e., large number of row numbers).
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.tri(n,Tr)$gen.points

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

t<-.5

Idom.numCSup.bnd.tri(Xp,1,Tr,t,M)

for (k in 1:n)
  print(c(k,Idom.numCSup.bnd.tri(Xp,k,Tr,t,M)))
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Idom.numCSup.bnd.std.tri}}, \code{\link{Idom.num.up.bnd}}, \code{\link{Idom.numASup.bnd.tri}},
and \code{\link{dom.num.exact}}
}
\author{
Elvan Ceyhan
}
