% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge3D.R
\name{Idom.num2PEtetra}
\alias{Idom.num2PEtetra}
\title{The indicator for two 3D points constituting a dominating set for Proportional Edge Proximity Catch Digraphs
(PE-PCDs) - one tetrahedron case}
\usage{
Idom.num2PEtetra(
  p1,
  p2,
  Xp,
  th,
  r,
  M = "CM",
  rv1 = NULL,
  rv2 = NULL,
  ch.data.pnts = FALSE
)
}
\arguments{
\item{p1, p2}{Two 3D points to be tested for constituting a dominating set of the PE-PCD.}

\item{Xp}{A set of 3D points which constitutes the vertices of the PE-PCD.}

\item{th}{A \eqn{4 \times 3} matrix with each row representing a vertex of the tetrahedron.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{The center to be used in the construction of the vertex regions in the tetrahedron, \code{th}.
Currently it only takes \code{"CC"} for circumcenter and \code{"CM"} for center of mass; default=\code{"CM"}.}

\item{rv1, rv2}{The indices of the vertices whose regions contains \code{p1} and \code{p2}, respectively.
They take the vertex labels as \code{1,2,3,4} as in the row order of the vertices in \code{th}
(default is \code{NULL} for both).}

\item{ch.data.pnts}{A logical argument for checking whether both points \code{p1} and \code{p2} are
data points in \code{Xp} or not (default is \code{FALSE}).}
}
\value{
\eqn{I(}\{\code{p1,p2}\} is a dominating set of the PE-PCD\eqn{)} where the vertices of the PE-PCD are the 3D data set \code{Xp}),
that is, returns 1 if \{\code{p1,p2}\} is a dominating set of PE-PCD, returns 0 otherwise
}
\description{
Returns \eqn{I(}\{\code{p1,p2}\} is a dominating set of the PE-PCD\eqn{)} where the vertices of the PE-PCD are the 3D data set \code{Xp} in the tetrahedron \code{th}, that is,
returns 1 if \{\code{p1,p2}\} is a dominating set of PE-PCD, returns 0 otherwise.

Point, \code{p1}, is in the region of vertex \code{rv1} (default is \code{NULL}) and point, \code{p2}, is in the region of vertex \code{rv2}
(default is \code{NULL}); vertices (and hence \code{rv1} and \code{rv2}) are labeled as \code{1,2,3,4} in the order they are stacked
row-wise in \code{th}.

PE proximity region is constructed with respect to the tetrahedron \code{th} with expansion parameter \eqn{r \ge 1}
and vertex regions are based on center of mass (\code{M="CM"}) or circumcenter (\code{M="CC"}) only.

\code{ch.data.pnts} is for checking whether points \code{p1} and \code{p2} are both data points in \code{Xp} or not (default is \code{FALSE}),
so by default this function checks whether the points \code{p1} and \code{p2} would constitute a dominating set
if they actually were both in the data set.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\donttest{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
tetra<-rbind(A,B,C,D)
n<-5

set.seed(1)
Xp<-runif.tetra(n,tetra)$g  #try also Xp<-cbind(runif(n),runif(n),runif(n))

M<-"CM";  #try also M<-"CC";
r<-1.5

Idom.num2PEtetra(Xp[1,],Xp[2,],Xp,tetra,r,M)
Idom.num2PEtetra(c(-1,-1,-1),Xp[2,],Xp,tetra,r,M)

ind.gam2<-ind.gamn2<-vector()
for (i in 1:(n-1))
 for (j in (i+1):n)
 {if (Idom.num2PEtetra(Xp[i,],Xp[j,],Xp,tetra,r,M)==1)
 {ind.gam2<-rbind(ind.gam2,c(i,j))
 }
 }
ind.gam2

#or try
rv1<-rel.vert.tetraCC(Xp[1,],tetra)$rv;rv2<-rel.vert.tetraCC(Xp[2,],tetra)$rv
Idom.num2PEtetra(Xp[1,],Xp[2,],Xp,tetra,r,M,rv1,rv2)

#or try
rv1<-rel.vert.tetraCC(Xp[1,],tetra)$rv;
Idom.num2PEtetra(Xp[1,],Xp[2,],Xp,tetra,r,M,rv1)

#or try
rv2<-rel.vert.tetraCC(Xp[2,],tetra)$rv
Idom.num2PEtetra(Xp[1,],Xp[2,],Xp,tetra,r,M,rv2=rv2)

P1<-c(.1,.1,.1)
P2<-c(.4,.1,.2)
Idom.num2PEtetra(P1,P2,Xp,tetra,r,M)

Idom.num2PEtetra(c(-1,-1,-1),Xp[2,],Xp,tetra,r,M,ch.data.pnts = FALSE)
#gives an error message if ch.data.pnts = TRUE
#since not both points, p1 and p2, are data points in Xp
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Idom.num2PEstd.tetra}}, \code{\link{Idom.num2PEtri}} and \code{\link{Idom.num2PEbasic.tri}}
}
\author{
Elvan Ceyhan
}
