% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{IarcCStri.alt}
\alias{IarcCStri.alt}
\title{An alternative to the function \code{\link{IarcCStri}} which yields the indicator
for the presence of an arc from one point to another
for Central Similarity Proximity Catch Digraphs (CS-PCDs)}
\usage{
IarcCStri.alt(p1, p2, tri, t, re = NULL)
}
\arguments{
\item{p1}{A 2D point whose CS proximity region is constructed.}

\item{p2}{A 2D point. The function determines whether \code{p2} is inside the CS proximity region of
\code{p1} or not.}

\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{re}{Index of the \eqn{CM}-edge region containing the point \code{p},
either \code{1,2,3} or \code{NULL}, default=\code{NULL} but
must be provided (row-wise) as vertices \eqn{(y_1,y_2,y_3)} for \code{re=3} as \eqn{(y_2,y_3,y_1)} for
\code{re=1} and as \eqn{(y_1,y_3,y_2)} for \code{re=2} for triangle \eqn{T(y_1,y_2,y_3)}.}
}
\value{
\eqn{I(}\code{p2} is in \eqn{N_{CS}(p1,t))} for \code{p1}, that is,
returns 1 if \code{p2} is in \eqn{N_{CS}(p1,t)}, returns 0 otherwise.
}
\description{
Returns \eqn{I(}\code{p2} is in \eqn{N_{CS}(p1,t))} for points \code{p1} and \code{p2}, that is, returns 1 if \code{p2} is in \eqn{N_{CS}(p1,t)},
returns 0 otherwise, where \eqn{N_{CS}(x,t)} is the CS proximity region for point \eqn{x} with the expansion parameter \eqn{t>0}.

CS proximity region is constructed with respect to the triangle \code{tri} and edge regions are based on the
center of mass, \eqn{CM}. \code{re} is the index of the \eqn{CM}-edge region \code{p} resides, with default=\code{NULL} but must be provided as
vertices \eqn{(y_1,y_2,y_3)} for \eqn{re=3} as rbind(y2,y3,y1) for \eqn{re=1} and as rbind(y1,y3,y2) for \eqn{re=2} for triangle \eqn{T(y_1,y_2,y_3)}.

If \code{p1} and \code{p2} are distinct and either of them are outside \code{tri}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}).
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.6,2);
Tr<-rbind(A,B,C);
t<-1.5

P1<-c(.4,.2)
P2<-c(1.8,.5)
IarcCStri(P1,P2,Tr,t,M=c(1,1,1))
IarcCStri.alt(P1,P2,Tr,t)

IarcCStri(P2,P1,Tr,t,M=c(1,1,1))
IarcCStri.alt(P2,P1,Tr,t)

#or try
re<-rel.edges.triCM(P1,Tr)$re
IarcCStri(P1,P2,Tr,t,M=c(1,1,1),re)
IarcCStri.alt(P1,P2,Tr,t,re)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IarcAStri}}, \code{\link{IarcPEtri}}, \code{\link{IarcCStri}}, and \code{\link{IarcCSstd.tri}}
}
\author{
Elvan Ceyhan
}
