% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceFunctions.R
\name{ASarc.dens.tri}
\alias{ASarc.dens.tri}
\title{Arc density of Arc Slice Proximity Catch Digraphs (AS-PCDs) - one triangle case}
\usage{
ASarc.dens.tri(Xp, tri, M = "CC", in.tri.only = FALSE)
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the AS-PCD.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{The center of the triangle. \code{"CC"} stands for circumcenter of the triangle \code{tri} or a 2D point in Cartesian coordinates or
a 3D point in barycentric coordinates which serves as a center in the interior of \code{tri};
default is \code{M="CC"} i.e., the circumcenter of \code{tri}.}

\item{in.tri.only}{A logical argument (default is \code{in.tri.only=FALSE})
for computing the arc density for only the points inside the triangle, \code{tri}.
That is,
if \code{in.tri.only=TRUE} arc density of the induced subdigraph with the vertices
inside \code{tri} is computed, otherwise
otherwise arc density of the entire digraph (i.e., digraph with all the vertices) is computed.}
}
\value{
Arc density of AS-PCD whose vertices are the 2D numerical data set, \code{Xp};
AS proximity regions are defined with respect to the triangle \code{tri} and \eqn{CC}-vertex regions.
}
\description{
Returns the arc density of AS-PCD whose vertex set is the given 2D numerical data set, \code{Xp},
(some of its members are) in the triangle \code{tri}.

AS proximity regions are defined with respect to \code{tri}
and vertex regions are defined with the center \code{M="CC"} for circumcenter of \code{tri};
or \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of the triangle \code{tri}; default is \code{M="CC"} i.e., circumcenter of \code{tri}.
For the number of arcs, loops are not allowed so arcs are only possible for points inside \code{tri}
for this function.

\code{in.tri.only} is a logical argument (default is \code{FALSE}) for considering only the points
inside the triangle or all the points as the vertices of the digraph.
if \code{in.tri.only=TRUE}, arc density is computed only for
the points inside the triangle (i.e., arc density of the subdigraph
induced by the vertices in the triangle is computed),
otherwise arc density of the entire digraph (i.e., digraph with all the vertices) is computed.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

set.seed(1)
n<-10  #try also n<-20

Xp<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.2)

narcs = num.arcsAStri(Xp,Tr,M)$num.arcs; narcs/(n*(n-1))
ASarc.dens.tri(Xp,Tr,M)
ASarc.dens.tri(Xp,Tr,M,in.tri.only = FALSE)

ASarc.dens.tri(Xp,Tr,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ASarc.dens.tri}}, \code{\link{CSarc.dens.tri}}, and \code{\link{num.arcsAStri}}
}
\author{
Elvan Ceyhan
}
