% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenario_pbox.R
\name{scenario_pbox}
\alias{scenario_pbox}
\alias{scenario_pbox,pbox-method}
\title{Scenario Analysis}
\usage{
scenario_pbox(
  pbx,
  param_list = "list",
  sigma = 0.05,
  range = seq(-3, 3, 1),
  ...
)

\S4method{scenario_pbox}{pbox}(
  pbx,
  param_list = "list",
  sigma = 0.05,
  range = seq(-3, 3, 1),
  ...
)
}
\arguments{
\item{pbx}{object of class pbox}

\item{param_list}{List specifying which parameters to modify.}

\item{sigma}{Standard deviation for parameter deviations, defaulting to 0.05.}

\item{range}{Range of deviation multipliers, default is seq(-3, 3, 1).}

\item{...}{Additional arguments passed to qpbox.}
}
\value{
Named list of results from each scenario evaluation.
}
\description{
Performs scenario analysis by modifying underlying parameters of a pbox object.
Query the probabilistic space under different scenarios with different combinations of parameters for a single query.
}
\examples{
  data("SEAex")
  pbx <- set_pbox(SEAex)
  scenario_pbox(pbx,mj = "Vietnam:31 & avgRegion:26", param_list = list(Vietnam="mu"))

}
