% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perProb.R
\name{perProb}
\alias{perProb}
\alias{perProb,pbox-method}
\title{Compute Probability Using a Perturbed Copula}
\usage{
perProb(x, vecQuery)

\S4method{perProb}{pbox}(x, vecQuery)
}
\arguments{
\item{x}{A 'pbox' object, which is expected to contain a copula.}

\item{vecQuery}{A numeric vector representing the query values.}
}
\value{
The probability computed using a perturbed copula.

Numeric value representing the computed probability using the perturbed copula.
}
\description{
Computes the probability by applying a perturbation to the copula parameters within a 'pbox' object,
and then evaluating the probability for specified query values. This method ensures that variations
in the copula parameters can be assessed for their impact on the computed probabilities.

`perProb` method for objects of class 'pbox'.
This method perturbs the parameters of the copula contained in the 'pbox'
and then computes the probability of the vector query using the perturbed copula.
The perturbation process adjusts the copula parameters and evaluates the impact
on the outcome probability.
}
\examples{
  data(SEAex)
  pbx <- set_pbox(SEAex[, .(Malaysia, Thailand)])
  vecQuery <- c(31, 34)
  perProb(pbx, vecQuery)
}
\seealso{
\code{\link{set_pbox}}, \code{\link{pMvdc}}
}
