% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_pbox.R
\name{grid_pbox}
\alias{grid_pbox}
\alias{grid_pbox,pbox-method}
\title{Iterate Over a Grid of All Possible Quantiles and Calculate Probabilities}
\usage{
grid_pbox(pbx, mj = character(), co = NULL, probs = seq(0, 1, 0.1), ...)

\S4method{grid_pbox}{pbox}(pbx, mj = character(), co = NULL, probs = seq(0, 1, 0.1), ...)
}
\arguments{
\item{pbx}{An object of class \code{pbox} from which to query the probabilistic space.}

\item{mj}{A character vector specifying the variables to query.}

\item{co}{A character vector specifying the variables to query}

\item{probs}{A numeric vector of quantiles to calculate probabilities for (default: seq(0, 1, 0.1)).}

\item{...}{Additional parameters passed to \code{qpbox}.}
}
\value{
A data.table containing estimated probabilities for each combination of quantiles and distributions queried.

A data.table containing estimated probabilities for each combination of quantiles and distributions queried.
}
\description{
This function queries the probabilistic space of a pbox object to calculate probabilities
associated with specific marginal or conditional distributions on a quantile grid. It supports conditional
probability calculations as well.

This method processes the \code{pbox} object to compute probabilities based on the specified marginal
and conditional parameters. It handles both simple probability calculations and complex queries involving
joint and conditional distributions, with an option for bootstrap confidence interval estimation.
}
\examples{
  data("SEAex")
  pbx <- set_pbox(SEAex)
  grid_pbox(pbx, mj = c("Vietnam", "Malaysia"))
}
