% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{ivsrealtime}
\alias{ivsrealtime}
\title{Amazon Interactive Video Service RealTime}
\usage{
ivsrealtime(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
The Amazon Interactive Video Service (IVS) real-time API is REST
compatible, using a standard HTTP API and an AWS EventBridge event
stream for responses. JSON is used for both requests and responses,
including errors.

\strong{Key Concepts}
\itemize{
\item \strong{Stage} — A virtual space where participants can exchange video in
real time.
\item \strong{Participant token} — A token that authenticates a participant
when they join a stage.
\item \strong{Participant object} — Represents participants (people) in the
stage and contains information about them. When a token is created,
it includes a participant ID; when a participant uses that token to
join a stage, the participant is associated with that participant
ID. There is a 1:1 mapping between participant tokens and
participants.
}

For server-side composition:
\itemize{
\item \strong{Composition process} — Composites participants of a stage into a
single video and forwards it to a set of outputs (e.g., IVS
channels). Composition operations support this process.
\item \strong{Composition} — Controls the look of the outputs, including how
participants are positioned in the video.
}

For more information about your IVS live stream, also see \href{https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started.html}{Getting Started with Amazon IVS Real-Time Streaming}.

\strong{Tagging}

A \emph{tag} is a metadata label that you assign to an AWS resource. A tag
comprises a \emph{key} and a \emph{value}, both set by you. For example, you might
set a tag as \code{topic:nature} to label a particular video category. See
\href{https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html}{Best practices and strategies}
in \emph{Tagging AWS Resources and Tag Editor} for details, including
restrictions that apply to tags and "Tag naming limits and
requirements"; Amazon IVS stages has no service-specific constraints
beyond what is documented there.

Tags can help you identify and organize your AWS resources. For example,
you can use the same tag for different resources to indicate that they
are related. You can also use tags to manage access (see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html}{Access Tags}).

The Amazon IVS real-time API has these tag-related operations:
\code{tag_resource},
\code{untag_resource}, and
\code{list_tags_for_resource}. The
following resource supports tagging: Stage.

At most 50 tags can be applied to a resource.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- ivsrealtime(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.analytics:ivsrealtime_create_encoder_configuration]{create_encoder_configuration} \tab Creates an EncoderConfiguration object\cr
\link[paws.analytics:ivsrealtime_create_ingest_configuration]{create_ingest_configuration} \tab Creates a new IngestConfiguration resource, used to specify the ingest protocol for a stage\cr
\link[paws.analytics:ivsrealtime_create_participant_token]{create_participant_token} \tab Creates an additional token for a specified stage\cr
\link[paws.analytics:ivsrealtime_create_stage]{create_stage} \tab Creates a new stage (and optionally participant tokens)\cr
\link[paws.analytics:ivsrealtime_create_storage_configuration]{create_storage_configuration} \tab Creates a new storage configuration, used to enable recording to Amazon S3\cr
\link[paws.analytics:ivsrealtime_delete_encoder_configuration]{delete_encoder_configuration} \tab Deletes an EncoderConfiguration resource\cr
\link[paws.analytics:ivsrealtime_delete_ingest_configuration]{delete_ingest_configuration} \tab Deletes a specified IngestConfiguration, so it can no longer be used to broadcast\cr
\link[paws.analytics:ivsrealtime_delete_public_key]{delete_public_key} \tab Deletes the specified public key used to sign stage participant tokens\cr
\link[paws.analytics:ivsrealtime_delete_stage]{delete_stage} \tab Shuts down and deletes the specified stage (disconnecting all participants)\cr
\link[paws.analytics:ivsrealtime_delete_storage_configuration]{delete_storage_configuration} \tab Deletes the storage configuration for the specified ARN\cr
\link[paws.analytics:ivsrealtime_disconnect_participant]{disconnect_participant} \tab Disconnects a specified participant from a specified stage\cr
\link[paws.analytics:ivsrealtime_get_composition]{get_composition} \tab Get information about the specified Composition resource\cr
\link[paws.analytics:ivsrealtime_get_encoder_configuration]{get_encoder_configuration} \tab Gets information about the specified EncoderConfiguration resource\cr
\link[paws.analytics:ivsrealtime_get_ingest_configuration]{get_ingest_configuration} \tab Gets information about the specified IngestConfiguration\cr
\link[paws.analytics:ivsrealtime_get_participant]{get_participant} \tab Gets information about the specified participant token\cr
\link[paws.analytics:ivsrealtime_get_public_key]{get_public_key} \tab Gets information for the specified public key\cr
\link[paws.analytics:ivsrealtime_get_stage]{get_stage} \tab Gets information for the specified stage\cr
\link[paws.analytics:ivsrealtime_get_stage_session]{get_stage_session} \tab Gets information for the specified stage session\cr
\link[paws.analytics:ivsrealtime_get_storage_configuration]{get_storage_configuration} \tab Gets the storage configuration for the specified ARN\cr
\link[paws.analytics:ivsrealtime_import_public_key]{import_public_key} \tab Import a public key to be used for signing stage participant tokens\cr
\link[paws.analytics:ivsrealtime_list_compositions]{list_compositions} \tab Gets summary information about all Compositions in your account, in the AWS region where the API request is processed\cr
\link[paws.analytics:ivsrealtime_list_encoder_configurations]{list_encoder_configurations} \tab Gets summary information about all EncoderConfigurations in your account, in the AWS region where the API request is processed\cr
\link[paws.analytics:ivsrealtime_list_ingest_configurations]{list_ingest_configurations} \tab Lists all IngestConfigurations in your account, in the AWS region where the API request is processed\cr
\link[paws.analytics:ivsrealtime_list_participant_events]{list_participant_events} \tab Lists events for a specified participant that occurred during a specified stage session\cr
\link[paws.analytics:ivsrealtime_list_participants]{list_participants} \tab Lists all participants in a specified stage session\cr
\link[paws.analytics:ivsrealtime_list_public_keys]{list_public_keys} \tab Gets summary information about all public keys in your account, in the AWS region where the API request is processed\cr
\link[paws.analytics:ivsrealtime_list_stages]{list_stages} \tab Gets summary information about all stages in your account, in the AWS region where the API request is processed\cr
\link[paws.analytics:ivsrealtime_list_stage_sessions]{list_stage_sessions} \tab Gets all sessions for a specified stage\cr
\link[paws.analytics:ivsrealtime_list_storage_configurations]{list_storage_configurations} \tab Gets summary information about all storage configurations in your account, in the AWS region where the API request is processed\cr
\link[paws.analytics:ivsrealtime_list_tags_for_resource]{list_tags_for_resource} \tab Gets information about AWS tags for the specified ARN\cr
\link[paws.analytics:ivsrealtime_start_composition]{start_composition} \tab Starts a Composition from a stage based on the configuration provided in the request\cr
\link[paws.analytics:ivsrealtime_stop_composition]{stop_composition} \tab Stops and deletes a Composition resource\cr
\link[paws.analytics:ivsrealtime_tag_resource]{tag_resource} \tab Adds or updates tags for the AWS resource with the specified ARN\cr
\link[paws.analytics:ivsrealtime_untag_resource]{untag_resource} \tab Removes tags from the resource with the specified ARN\cr
\link[paws.analytics:ivsrealtime_update_ingest_configuration]{update_ingest_configuration} \tab Updates a specified IngestConfiguration\cr
\link[paws.analytics:ivsrealtime_update_stage]{update_stage} \tab Updates a stage’s configuration
}
}

\examples{
\dontrun{
svc <- ivsrealtime()
svc$create_encoder_configuration(
  Foo = 123
)
}

}
