% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_initiate_multipart_upload}
\alias{glacier_initiate_multipart_upload}
\title{This operation initiates a multipart upload}
\usage{
glacier_initiate_multipart_upload(
  accountId,
  vaultName,
  archiveDescription = NULL,
  partSize = NULL
)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID of the account that owns the
vault. You can either specify an AWS account ID or optionally a single
'\code{-}' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
associated with the credentials used to sign the request. If you use an
account ID, do not include any hyphens ('-') in the ID.}

\item{vaultName}{[required] The name of the vault.}

\item{archiveDescription}{The archive description that you are uploading in parts.

The part size must be a megabyte (1024 KB) multiplied by a power of 2,
for example 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608 (8
MB), and so on. The minimum allowable part size is 1 MB, and the maximum
is 4 GB (4096 MB).}

\item{partSize}{The size of each part except the last, in bytes. The last part can be
smaller than this part size.}
}
\description{
This operation initiates a multipart upload. Amazon S3 Glacier creates a multipart upload resource and returns its ID in the response. The multipart upload ID is used in subsequent requests to upload parts of an archive (see \code{\link[=glacier_upload_multipart_part]{upload_multipart_part}}).

See \url{https://www.paws-r-sdk.com/docs/glacier_initiate_multipart_upload/} for full documentation.
}
\keyword{internal}
