% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspace_operations.R
\name{finspace_update_kx_dataview}
\alias{finspace_update_kx_dataview}
\title{Updates the specified dataview}
\usage{
finspace_update_kx_dataview(
  environmentId,
  databaseName,
  dataviewName,
  description = NULL,
  changesetId = NULL,
  segmentConfigurations = NULL,
  clientToken
)
}
\arguments{
\item{environmentId}{[required] A unique identifier for the kdb environment, where you want to update
the dataview.}

\item{databaseName}{[required] The name of the database.}

\item{dataviewName}{[required] The name of the dataview that you want to update.}

\item{description}{The description for a dataview.}

\item{changesetId}{A unique identifier for the changeset.}

\item{segmentConfigurations}{The configuration that contains the database path of the data that you
want to place on each selected volume. Each segment must have a unique
database path for each volume. If you do not explicitly specify any
database path for a volume, they are accessible from the cluster through
the default S3/object store segment.}

\item{clientToken}{[required] A token that ensures idempotency. This token expires in 10 minutes.}
}
\description{
Updates the specified dataview. The dataviews get automatically updated when any new changesets are ingested. Each update of the dataview creates a new version, including changeset details and cache configurations

See \url{https://www.paws-r-sdk.com/docs/finspace_update_kx_dataview/} for full documentation.
}
\keyword{internal}
