% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_create_event_data_store}
\alias{cloudtrail_create_event_data_store}
\title{Creates a new event data store}
\usage{
cloudtrail_create_event_data_store(
  Name,
  AdvancedEventSelectors = NULL,
  MultiRegionEnabled = NULL,
  OrganizationEnabled = NULL,
  RetentionPeriod = NULL,
  TerminationProtectionEnabled = NULL,
  TagsList = NULL,
  KmsKeyId = NULL,
  StartIngestion = NULL,
  BillingMode = NULL
)
}
\arguments{
\item{Name}{[required] The name of the event data store.}

\item{AdvancedEventSelectors}{The advanced event selectors to use to select the events for the data
store. You can configure up to five advanced event selectors for each
event data store.

For more information about how to use advanced event selectors to log
CloudTrail events, see \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced}{Log events by using advanced event selectors}
in the CloudTrail User Guide.

For more information about how to use advanced event selectors to
include Config configuration items in your event data store, see \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-eds-cli.html#lake-cli-create-eds-config}{Create an event data store for Config configuration items}
in the CloudTrail User Guide.

For more information about how to use advanced event selectors to
include events outside of Amazon Web Services events in your event data
store, see \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-integrations-cli.html#lake-cli-create-integration}{Create an integration to log events from outside Amazon Web Services}
in the CloudTrail User Guide.}

\item{MultiRegionEnabled}{Specifies whether the event data store includes events from all Regions,
or only from the Region in which the event data store is created.}

\item{OrganizationEnabled}{Specifies whether an event data store collects events logged for an
organization in Organizations.}

\item{RetentionPeriod}{The retention period of the event data store, in days. If \code{BillingMode}
is set to \code{EXTENDABLE_RETENTION_PRICING}, you can set a retention period
of up to 3653 days, the equivalent of 10 years. If \code{BillingMode} is set
to \code{FIXED_RETENTION_PRICING}, you can set a retention period of up to
2557 days, the equivalent of seven years.

CloudTrail Lake determines whether to retain an event by checking if the
\code{eventTime} of the event is within the specified retention period. For
example, if you set a retention period of 90 days, CloudTrail will
remove events when the \code{eventTime} is older than 90 days.

If you plan to copy trail events to this event data store, we recommend
that you consider both the age of the events that you want to copy as
well as how long you want to keep the copied events in your event data
store. For example, if you copy trail events that are 5 years old and
specify a retention period of 7 years, the event data store will retain
those events for two years.}

\item{TerminationProtectionEnabled}{Specifies whether termination protection is enabled for the event data
store. If termination protection is enabled, you cannot delete the event
data store until termination protection is disabled.}

\item{TagsList}{}

\item{KmsKeyId}{Specifies the KMS key ID to use to encrypt the events delivered by
CloudTrail. The value can be an alias name prefixed by \verb{alias/}, a fully
specified ARN to an alias, a fully specified ARN to a key, or a globally
unique identifier.

Disabling or deleting the KMS key, or removing CloudTrail permissions on
the key, prevents CloudTrail from logging events to the event data
store, and prevents users from querying the data in the event data store
that was encrypted with the key. After you associate an event data store
with a KMS key, the KMS key cannot be removed or changed. Before you
disable or delete a KMS key that you are using with an event data store,
delete or back up your event data store.

CloudTrail also supports KMS multi-Region keys. For more information
about multi-Region keys, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html}{Using multi-Region keys}
in the \emph{Key Management Service Developer Guide}.

Examples:
\itemize{
\item \code{alias/MyAliasName}
\item \code{arn:aws:kms:us-east-2:123456789012:alias/MyAliasName}
\item \code{arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012}
\item \code{12345678-1234-1234-1234-123456789012}
}}

\item{StartIngestion}{Specifies whether the event data store should start ingesting live
events. The default is true.}

\item{BillingMode}{The billing mode for the event data store determines the cost for
ingesting events and the default and maximum retention period for the
event data store.

The following are the possible values:
\itemize{
\item \code{EXTENDABLE_RETENTION_PRICING} - This billing mode is generally
recommended if you want a flexible retention period of up to 3653
days (about 10 years). The default retention period for this billing
mode is 366 days.
\item \code{FIXED_RETENTION_PRICING} - This billing mode is recommended if you
expect to ingest more than 25 TB of event data per month and need a
retention period of up to 2557 days (about 7 years). The default
retention period for this billing mode is 2557 days.
}

The default value is \code{EXTENDABLE_RETENTION_PRICING}.

For more information about CloudTrail pricing, see \href{https://aws.amazon.com/cloudtrail/pricing/}{CloudTrail Pricing} and \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-manage-costs.html}{Managing CloudTrail Lake costs}.}
}
\description{
Creates a new event data store.

See \url{https://www.paws-r-sdk.com/docs/cloudtrail_create_event_data_store/} for full documentation.
}
\keyword{internal}
