% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_put_lifecycle_hook}
\alias{autoscaling_put_lifecycle_hook}
\title{Creates or updates a lifecycle hook for the specified Auto Scaling group}
\usage{
autoscaling_put_lifecycle_hook(
  LifecycleHookName,
  AutoScalingGroupName,
  LifecycleTransition = NULL,
  RoleARN = NULL,
  NotificationTargetARN = NULL,
  NotificationMetadata = NULL,
  HeartbeatTimeout = NULL,
  DefaultResult = NULL
)
}
\arguments{
\item{LifecycleHookName}{[required] The name of the lifecycle hook.}

\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{LifecycleTransition}{The lifecycle transition. For Auto Scaling groups, there are two major
lifecycle transitions.
\itemize{
\item To create a lifecycle hook for scale-out events, specify
\code{autoscaling:EC2_INSTANCE_LAUNCHING}.
\item To create a lifecycle hook for scale-in events, specify
\code{autoscaling:EC2_INSTANCE_TERMINATING}.
}

Required for new lifecycle hooks, but optional when updating existing
hooks.}

\item{RoleARN}{The ARN of the IAM role that allows the Auto Scaling group to publish to
the specified notification target.

Valid only if the notification target is an Amazon SNS topic or an
Amazon SQS queue. Required for new lifecycle hooks, but optional when
updating existing hooks.}

\item{NotificationTargetARN}{The Amazon Resource Name (ARN) of the notification target that Amazon
EC2 Auto Scaling uses to notify you when an instance is in a wait state
for the lifecycle hook. You can specify either an Amazon SNS topic or an
Amazon SQS queue.

If you specify an empty string, this overrides the current ARN.

This operation uses the JSON format when sending notifications to an
Amazon SQS queue, and an email key-value pair format when sending
notifications to an Amazon SNS topic.

When you specify a notification target, Amazon EC2 Auto Scaling sends it
a test message. Test messages contain the following additional key-value
pair: \code{"Event": "autoscaling:TEST_NOTIFICATION"}.}

\item{NotificationMetadata}{Additional information that you want to include any time Amazon EC2 Auto
Scaling sends a message to the notification target.}

\item{HeartbeatTimeout}{The maximum time, in seconds, that can elapse before the lifecycle hook
times out. The range is from \code{30} to \code{7200} seconds. The default value
is \code{3600} seconds (1 hour).}

\item{DefaultResult}{The action the Auto Scaling group takes when the lifecycle hook timeout
elapses or if an unexpected failure occurs. The default value is
\code{ABANDON}.

Valid values: \code{CONTINUE} | \code{ABANDON}}
}
\description{
Creates or updates a lifecycle hook for the specified Auto Scaling group.

See \url{https://www.paws-r-sdk.com/docs/autoscaling_put_lifecycle_hook/} for full documentation.
}
\keyword{internal}
