% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_create_auto_scaling_group}
\alias{autoscaling_create_auto_scaling_group}
\title{We strongly recommend using a launch template when calling this
operation to ensure full functionality for Amazon EC2 Auto Scaling and
Amazon EC2}
\usage{
autoscaling_create_auto_scaling_group(
  AutoScalingGroupName,
  LaunchConfigurationName = NULL,
  LaunchTemplate = NULL,
  MixedInstancesPolicy = NULL,
  InstanceId = NULL,
  MinSize,
  MaxSize,
  DesiredCapacity = NULL,
  DefaultCooldown = NULL,
  AvailabilityZones = NULL,
  LoadBalancerNames = NULL,
  TargetGroupARNs = NULL,
  HealthCheckType = NULL,
  HealthCheckGracePeriod = NULL,
  PlacementGroup = NULL,
  VPCZoneIdentifier = NULL,
  TerminationPolicies = NULL,
  NewInstancesProtectedFromScaleIn = NULL,
  CapacityRebalance = NULL,
  LifecycleHookSpecificationList = NULL,
  Tags = NULL,
  ServiceLinkedRoleARN = NULL,
  MaxInstanceLifetime = NULL,
  Context = NULL,
  DesiredCapacityType = NULL,
  DefaultInstanceWarmup = NULL,
  TrafficSources = NULL,
  InstanceMaintenancePolicy = NULL,
  AvailabilityZoneDistribution = NULL,
  AvailabilityZoneImpairmentPolicy = NULL,
  SkipZonalShiftValidation = NULL,
  CapacityReservationSpecification = NULL
)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group. This name must be unique per Region
per account.

The name can contain any ASCII character 33 to 126 including most
punctuation characters, digits, and upper and lowercased letters.

You cannot use a colon (:) in the name.}

\item{LaunchConfigurationName}{The name of the launch configuration to use to launch instances.

Conditional: You must specify either a launch template (\code{LaunchTemplate}
or \code{MixedInstancesPolicy}) or a launch configuration
(\code{LaunchConfigurationName} or \code{InstanceId}).}

\item{LaunchTemplate}{Information used to specify the launch template and version to use to
launch instances.

Conditional: You must specify either a launch template (\code{LaunchTemplate}
or \code{MixedInstancesPolicy}) or a launch configuration
(\code{LaunchConfigurationName} or \code{InstanceId}).

The launch template that is specified must be configured for use with an
Auto Scaling group. For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-template.html}{Create a launch template for an Auto Scaling group}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{MixedInstancesPolicy}{The mixed instances policy. For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html}{Auto Scaling groups with multiple instance types and purchase options}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{InstanceId}{The ID of the instance used to base the launch configuration on. If
specified, Amazon EC2 Auto Scaling uses the configuration values from
the specified instance to create a new launch configuration. To get the
instance ID, use the Amazon EC2
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html}{DescribeInstances}
API operation. For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html}{Create an Auto Scaling group using parameters from an existing instance}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{MinSize}{[required] The minimum size of the group.}

\item{MaxSize}{[required] The maximum size of the group.

With a mixed instances policy that uses instance weighting, Amazon EC2
Auto Scaling may need to go above \code{MaxSize} to meet your capacity
requirements. In this event, Amazon EC2 Auto Scaling will never go above
\code{MaxSize} by more than your largest instance weight (weights that define
how many units each instance contributes to the desired capacity of the
group).}

\item{DesiredCapacity}{The desired capacity is the initial capacity of the Auto Scaling group
at the time of its creation and the capacity it attempts to maintain. It
can scale beyond this capacity if you configure auto scaling. This
number must be greater than or equal to the minimum size of the group
and less than or equal to the maximum size of the group. If you do not
specify a desired capacity, the default is the minimum size of the
group.}

\item{DefaultCooldown}{\emph{Only needed if you use simple scaling policies.}

The amount of time, in seconds, between one scaling activity ending and
another one starting due to simple scaling policies. For more
information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-scaling-cooldowns.html}{Scaling cooldowns for Amazon EC2 Auto Scaling}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

Default: \code{300} seconds}

\item{AvailabilityZones}{A list of Availability Zones where instances in the Auto Scaling group
can be created. Used for launching into the default VPC subnet in each
Availability Zone when not using the \code{VPCZoneIdentifier} property, or
for attaching a network interface when an existing network interface ID
is specified in a launch template.}

\item{LoadBalancerNames}{A list of Classic Load Balancers associated with this Auto Scaling
group. For Application Load Balancers, Network Load Balancers, and
Gateway Load Balancers, specify the \code{TargetGroupARNs} property instead.}

\item{TargetGroupARNs}{The Amazon Resource Names (ARN) of the Elastic Load Balancing target
groups to associate with the Auto Scaling group. Instances are
registered as targets with the target groups. The target groups receive
incoming traffic and route requests to one or more registered targets.
For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html}{Use Elastic Load Balancing to distribute traffic across the instances in your Auto Scaling group}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{HealthCheckType}{A comma-separated value string of one or more health check types.

The valid values are \code{EC2}, \code{EBS}, \code{ELB}, and \code{VPC_LATTICE}. \code{EC2} is
the default health check and cannot be disabled. For more information,
see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-health-checks.html}{Health checks for instances in an Auto Scaling group}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

Only specify \code{EC2} if you must clear a value that was previously set.}

\item{HealthCheckGracePeriod}{The amount of time, in seconds, that Amazon EC2 Auto Scaling waits
before checking the health status of an EC2 instance that has come into
service and marking it unhealthy due to a failed health check. This is
useful if your instances do not immediately pass their health checks
after they enter the \code{InService} state. For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html}{Set the health check grace period for an Auto Scaling group}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

Default: \code{0} seconds}

\item{PlacementGroup}{The name of the placement group into which to launch your instances. For
more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html}{Placement groups}
in the \emph{Amazon EC2 User Guide for Linux Instances}.

A \emph{cluster} placement group is a logical grouping of instances within a
single Availability Zone. You cannot specify multiple Availability Zones
and a cluster placement group.}

\item{VPCZoneIdentifier}{A comma-separated list of subnet IDs for a virtual private cloud (VPC)
where instances in the Auto Scaling group can be created. If you specify
\code{VPCZoneIdentifier} with \code{AvailabilityZones}, the subnets that you
specify must reside in those Availability Zones.}

\item{TerminationPolicies}{A policy or a list of policies that are used to select the instance to
terminate. These policies are executed in the order that you list them.
For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html}{Configure termination policies for Amazon EC2 Auto Scaling}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

Valid values: \code{Default} | \code{AllocationStrategy} |
\code{ClosestToNextInstanceHour} | \code{NewestInstance} | \code{OldestInstance} |
\code{OldestLaunchConfiguration} | \code{OldestLaunchTemplate} |
\verb{arn:aws:lambda:region:account-id:function:my-function:my-alias}}

\item{NewInstancesProtectedFromScaleIn}{Indicates whether newly launched instances are protected from
termination by Amazon EC2 Auto Scaling when scaling in. For more
information about preventing instances from terminating on scale in, see
\href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html}{Use instance scale-in protection}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{CapacityRebalance}{Indicates whether Capacity Rebalancing is enabled. Otherwise, Capacity
Rebalancing is disabled. When you turn on Capacity Rebalancing, Amazon
EC2 Auto Scaling attempts to launch a Spot Instance whenever Amazon EC2
notifies that a Spot Instance is at an elevated risk of interruption.
After launching a new instance, it then terminates an old instance. For
more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html}{Use Capacity Rebalancing to handle Amazon EC2 Spot Interruptions}
in the in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{LifecycleHookSpecificationList}{One or more lifecycle hooks to add to the Auto Scaling group before
instances are launched.}

\item{Tags}{One or more tags. You can tag your Auto Scaling group and propagate the
tags to the Amazon EC2 instances it launches. Tags are not propagated to
Amazon EBS volumes. To add tags to Amazon EBS volumes, specify the tags
in a launch template but use caution. If the launch template specifies
an instance tag with a key that is also specified for the Auto Scaling
group, Amazon EC2 Auto Scaling overrides the value of that instance tag
with the value specified by the Auto Scaling group. For more
information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html}{Tag Auto Scaling groups and instances}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{ServiceLinkedRoleARN}{The Amazon Resource Name (ARN) of the service-linked role that the Auto
Scaling group uses to call other Amazon Web Services service on your
behalf. By default, Amazon EC2 Auto Scaling uses a service-linked role
named \code{AWSServiceRoleForAutoScaling}, which it creates if it does not
exist. For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html}{Service-linked roles}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{MaxInstanceLifetime}{The maximum amount of time, in seconds, that an instance can be in
service. The default is null. If specified, the value must be either 0
or a number equal to or greater than 86,400 seconds (1 day). For more
information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html}{Replace Auto Scaling instances based on maximum instance lifetime}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{Context}{Reserved.}

\item{DesiredCapacityType}{The unit of measurement for the value specified for desired capacity.
Amazon EC2 Auto Scaling supports \code{DesiredCapacityType} for
attribute-based instance type selection only. For more information, see
\href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-mixed-instances-group-attribute-based-instance-type-selection.html}{Create a mixed instances group using attribute-based instance type selection}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

By default, Amazon EC2 Auto Scaling specifies \code{units}, which translates
into number of instances.

Valid values: \code{units} | \code{vcpu} | \code{memory-mib}}

\item{DefaultInstanceWarmup}{The amount of time, in seconds, until a new instance is considered to
have finished initializing and resource consumption to become stable
after it enters the \code{InService} state.

During an instance refresh, Amazon EC2 Auto Scaling waits for the
warm-up period after it replaces an instance before it moves on to
replacing the next instance. Amazon EC2 Auto Scaling also waits for the
warm-up period before aggregating the metrics for new instances with
existing instances in the Amazon CloudWatch metrics that are used for
scaling, resulting in more reliable usage data. For more information,
see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html}{Set the default instance warmup for an Auto Scaling group}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

To manage various warm-up settings at the group level, we recommend that
you set the default instance warmup, \emph{even if it is set to 0 seconds}.
To remove a value that you previously set, include the property but
specify \code{-1} for the value. However, we strongly recommend keeping the
default instance warmup enabled by specifying a value of \code{0} or other
nominal value.

Default: None}

\item{TrafficSources}{The list of traffic sources to attach to this Auto Scaling group. You
can use any of the following as traffic sources for an Auto Scaling
group: Classic Load Balancer, Application Load Balancer, Gateway Load
Balancer, Network Load Balancer, and VPC Lattice.}

\item{InstanceMaintenancePolicy}{An instance maintenance policy. For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-maintenance-policy.html}{Set instance maintenance policy}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{AvailabilityZoneDistribution}{The instance capacity distribution across Availability Zones.}

\item{AvailabilityZoneImpairmentPolicy}{The policy for Availability Zone impairment.}

\item{SkipZonalShiftValidation}{If you enable zonal shift with cross-zone disabled load balancers,
capacity could become imbalanced across Availability Zones. To skip the
validation, specify \code{true}. For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-zonal-shift.html}{Auto Scaling group zonal shift}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{CapacityReservationSpecification}{The capacity reservation specification for the Auto Scaling group.}
}
\description{
\strong{We strongly recommend using a launch template when calling this operation to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2.}

See \url{https://www.paws-r-sdk.com/docs/autoscaling_create_auto_scaling_group/} for full documentation.
}
\keyword{internal}
