# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudtrail_service.R
NULL

#' Adds one or more tags to a trail, event data store, dashboard, or
#' channel, up to a limit of 50
#'
#' @description
#' Adds one or more tags to a trail, event data store, dashboard, or channel, up to a limit of 50. Overwrites an existing tag's value when a new value is specified for an existing tag key. Tag key names must be unique; you cannot have two keys with the same name but different values. If you specify a key without a value, the tag will be created with the specified key and a value of null. You can tag a trail or event data store that applies to all Amazon Web Services Regions only from the Region in which the trail or event data store was created (also known as its home Region).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_add_tags/](https://www.paws-r-sdk.com/docs/cloudtrail_add_tags/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; Specifies the ARN of the trail, event data store, dashboard, or channel
#' to which one or more tags will be added.
#' 
#' The format of a trail ARN is:
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' 
#' The format of an event data store ARN is:
#' `arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
#' 
#' The format of a dashboard ARN is:
#' `arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash`
#' 
#' The format of a channel ARN is:
#' `arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890`
#' @param TagsList &#91;required&#93; Contains a list of tags, up to a limit of 50
#'
#' @keywords internal
#'
#' @rdname cloudtrail_add_tags
cloudtrail_add_tags <- function(ResourceId, TagsList) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$add_tags_input(ResourceId = ResourceId, TagsList = TagsList)
  output <- .cloudtrail$add_tags_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$add_tags <- cloudtrail_add_tags

#' Cancels a query if the query is not in a terminated state, such as
#' CANCELLED, FAILED, TIMED_OUT, or FINISHED
#'
#' @description
#' Cancels a query if the query is not in a terminated state, such as `CANCELLED`, `FAILED`, `TIMED_OUT`, or `FINISHED`. You must specify an ARN value for `EventDataStore`. The ID of the query that you want to cancel is also required. When you run [`cancel_query`][cloudtrail_cancel_query], the query status might show as `CANCELLED` even if the operation is not yet finished.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_cancel_query/](https://www.paws-r-sdk.com/docs/cloudtrail_cancel_query/) for full documentation.
#'
#' @param EventDataStore The ARN (or the ID suffix of the ARN) of an event data store on which
#' the specified query is running.
#' @param QueryId &#91;required&#93; The ID of the query that you want to cancel. The `QueryId` comes from
#' the response of a [`start_query`][cloudtrail_start_query] operation.
#' @param EventDataStoreOwnerAccountId The account ID of the event data store owner.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_cancel_query
cloudtrail_cancel_query <- function(EventDataStore = NULL, QueryId, EventDataStoreOwnerAccountId = NULL) {
  op <- new_operation(
    name = "CancelQuery",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$cancel_query_input(EventDataStore = EventDataStore, QueryId = QueryId, EventDataStoreOwnerAccountId = EventDataStoreOwnerAccountId)
  output <- .cloudtrail$cancel_query_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$cancel_query <- cloudtrail_cancel_query

#' Creates a channel for CloudTrail to ingest events from a partner or
#' external source
#'
#' @description
#' Creates a channel for CloudTrail to ingest events from a partner or external source. After you create a channel, a CloudTrail Lake event data store can log events from the partner or source that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_create_channel/](https://www.paws-r-sdk.com/docs/cloudtrail_create_channel/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the channel.
#' @param Source &#91;required&#93; The name of the partner or external event source. You cannot change this
#' name after you create the channel. A maximum of one channel is allowed
#' per source.
#' 
#' A source can be either `Custom` for all valid non-Amazon Web Services
#' events, or the name of a partner event source. For information about the
#' source names for available partners, see [Additional information about
#' integration
#' partners](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-event-data-store-integration.html#cloudtrail-lake-partner-information)
#' in the CloudTrail User Guide.
#' @param Destinations &#91;required&#93; One or more event data stores to which events arriving through a channel
#' will be logged.
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname cloudtrail_create_channel
cloudtrail_create_channel <- function(Name, Source, Destinations, Tags = NULL) {
  op <- new_operation(
    name = "CreateChannel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$create_channel_input(Name = Name, Source = Source, Destinations = Destinations, Tags = Tags)
  output <- .cloudtrail$create_channel_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$create_channel <- cloudtrail_create_channel

#' Creates a custom dashboard or the Highlights dashboard
#'
#' @description
#' Creates a custom dashboard or the Highlights dashboard.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_create_dashboard/](https://www.paws-r-sdk.com/docs/cloudtrail_create_dashboard/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the dashboard. The name must be unique to your account.
#' 
#' To create the Highlights dashboard, the name must be
#' `AWSCloudTrail-Highlights`.
#' @param RefreshSchedule The refresh schedule configuration for the dashboard.
#' 
#' To create the Highlights dashboard, you must set a refresh schedule and
#' set the `Status` to `ENABLED`. The `Unit` for the refresh schedule must
#' be `HOURS` and the `Value` must be `6`.
#' @param TagsList 
#' @param TerminationProtectionEnabled Specifies whether termination protection is enabled for the dashboard.
#' If termination protection is enabled, you cannot delete the dashboard
#' until termination protection is disabled.
#' @param Widgets An array of widgets for a custom dashboard. A custom dashboard can have
#' a maximum of ten widgets.
#' 
#' You do not need to specify widgets for the Highlights dashboard.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_create_dashboard
cloudtrail_create_dashboard <- function(Name, RefreshSchedule = NULL, TagsList = NULL, TerminationProtectionEnabled = NULL, Widgets = NULL) {
  op <- new_operation(
    name = "CreateDashboard",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$create_dashboard_input(Name = Name, RefreshSchedule = RefreshSchedule, TagsList = TagsList, TerminationProtectionEnabled = TerminationProtectionEnabled, Widgets = Widgets)
  output <- .cloudtrail$create_dashboard_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$create_dashboard <- cloudtrail_create_dashboard

#' Creates a new event data store
#'
#' @description
#' Creates a new event data store.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_create_event_data_store/](https://www.paws-r-sdk.com/docs/cloudtrail_create_event_data_store/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the event data store.
#' @param AdvancedEventSelectors The advanced event selectors to use to select the events for the data
#' store. You can configure up to five advanced event selectors for each
#' event data store.
#' 
#' For more information about how to use advanced event selectors to log
#' CloudTrail events, see [Log events by using advanced event
#' selectors](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced)
#' in the CloudTrail User Guide.
#' 
#' For more information about how to use advanced event selectors to
#' include Config configuration items in your event data store, see [Create
#' an event data store for Config configuration
#' items](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-eds-cli.html#lake-cli-create-eds-config)
#' in the CloudTrail User Guide.
#' 
#' For more information about how to use advanced event selectors to
#' include events outside of Amazon Web Services events in your event data
#' store, see [Create an integration to log events from outside Amazon Web
#' Services](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-integrations-cli.html#lake-cli-create-integration)
#' in the CloudTrail User Guide.
#' @param MultiRegionEnabled Specifies whether the event data store includes events from all Regions,
#' or only from the Region in which the event data store is created.
#' @param OrganizationEnabled Specifies whether an event data store collects events logged for an
#' organization in Organizations.
#' @param RetentionPeriod The retention period of the event data store, in days. If `BillingMode`
#' is set to `EXTENDABLE_RETENTION_PRICING`, you can set a retention period
#' of up to 3653 days, the equivalent of 10 years. If `BillingMode` is set
#' to `FIXED_RETENTION_PRICING`, you can set a retention period of up to
#' 2557 days, the equivalent of seven years.
#' 
#' CloudTrail Lake determines whether to retain an event by checking if the
#' `eventTime` of the event is within the specified retention period. For
#' example, if you set a retention period of 90 days, CloudTrail will
#' remove events when the `eventTime` is older than 90 days.
#' 
#' If you plan to copy trail events to this event data store, we recommend
#' that you consider both the age of the events that you want to copy as
#' well as how long you want to keep the copied events in your event data
#' store. For example, if you copy trail events that are 5 years old and
#' specify a retention period of 7 years, the event data store will retain
#' those events for two years.
#' @param TerminationProtectionEnabled Specifies whether termination protection is enabled for the event data
#' store. If termination protection is enabled, you cannot delete the event
#' data store until termination protection is disabled.
#' @param TagsList 
#' @param KmsKeyId Specifies the KMS key ID to use to encrypt the events delivered by
#' CloudTrail. The value can be an alias name prefixed by `alias/`, a fully
#' specified ARN to an alias, a fully specified ARN to a key, or a globally
#' unique identifier.
#' 
#' Disabling or deleting the KMS key, or removing CloudTrail permissions on
#' the key, prevents CloudTrail from logging events to the event data
#' store, and prevents users from querying the data in the event data store
#' that was encrypted with the key. After you associate an event data store
#' with a KMS key, the KMS key cannot be removed or changed. Before you
#' disable or delete a KMS key that you are using with an event data store,
#' delete or back up your event data store.
#' 
#' CloudTrail also supports KMS multi-Region keys. For more information
#' about multi-Region keys, see [Using multi-Region
#' keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
#' in the *Key Management Service Developer Guide*.
#' 
#' Examples:
#' 
#' -   `alias/MyAliasName`
#' 
#' -   `arn:aws:kms:us-east-2:123456789012:alias/MyAliasName`
#' 
#' -   `arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012`
#' 
#' -   `12345678-1234-1234-1234-123456789012`
#' @param StartIngestion Specifies whether the event data store should start ingesting live
#' events. The default is true.
#' @param BillingMode The billing mode for the event data store determines the cost for
#' ingesting events and the default and maximum retention period for the
#' event data store.
#' 
#' The following are the possible values:
#' 
#' -   `EXTENDABLE_RETENTION_PRICING` - This billing mode is generally
#'     recommended if you want a flexible retention period of up to 3653
#'     days (about 10 years). The default retention period for this billing
#'     mode is 366 days.
#' 
#' -   `FIXED_RETENTION_PRICING` - This billing mode is recommended if you
#'     expect to ingest more than 25 TB of event data per month and need a
#'     retention period of up to 2557 days (about 7 years). The default
#'     retention period for this billing mode is 2557 days.
#' 
#' The default value is `EXTENDABLE_RETENTION_PRICING`.
#' 
#' For more information about CloudTrail pricing, see [CloudTrail
#' Pricing](https://aws.amazon.com/cloudtrail/pricing/) and [Managing
#' CloudTrail Lake
#' costs](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-manage-costs.html).
#'
#' @keywords internal
#'
#' @rdname cloudtrail_create_event_data_store
cloudtrail_create_event_data_store <- function(Name, AdvancedEventSelectors = NULL, MultiRegionEnabled = NULL, OrganizationEnabled = NULL, RetentionPeriod = NULL, TerminationProtectionEnabled = NULL, TagsList = NULL, KmsKeyId = NULL, StartIngestion = NULL, BillingMode = NULL) {
  op <- new_operation(
    name = "CreateEventDataStore",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$create_event_data_store_input(Name = Name, AdvancedEventSelectors = AdvancedEventSelectors, MultiRegionEnabled = MultiRegionEnabled, OrganizationEnabled = OrganizationEnabled, RetentionPeriod = RetentionPeriod, TerminationProtectionEnabled = TerminationProtectionEnabled, TagsList = TagsList, KmsKeyId = KmsKeyId, StartIngestion = StartIngestion, BillingMode = BillingMode)
  output <- .cloudtrail$create_event_data_store_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$create_event_data_store <- cloudtrail_create_event_data_store

#' Creates a trail that specifies the settings for delivery of log data to
#' an Amazon S3 bucket
#'
#' @description
#' Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_create_trail/](https://www.paws-r-sdk.com/docs/cloudtrail_create_trail/) for full documentation.
#'
#' @param Name &#91;required&#93; Specifies the name of the trail. The name must meet the following
#' requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are not valid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' @param S3BucketName &#91;required&#93; Specifies the name of the Amazon S3 bucket designated for publishing log
#' files. For information about bucket naming rules, see [Bucket naming
#' rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html)
#' in the *Amazon Simple Storage Service User Guide*.
#' @param S3KeyPrefix Specifies the Amazon S3 key prefix that comes after the name of the
#' bucket you have designated for log file delivery. For more information,
#' see [Finding Your CloudTrail Log
#' Files](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/get-and-view-cloudtrail-log-files.html#cloudtrail-find-log-files).
#' The maximum length is 200 characters.
#' @param SnsTopicName Specifies the name of the Amazon SNS topic defined for notification of
#' log file delivery. The maximum length is 256 characters.
#' @param IncludeGlobalServiceEvents Specifies whether the trail is publishing events from global services
#' such as IAM to the log files.
#' @param IsMultiRegionTrail Specifies whether the trail is created in the current Region or in all
#' Regions. The default is false, which creates a trail only in the Region
#' where you are signed in. As a best practice, consider creating trails
#' that log events in all Regions.
#' @param EnableLogFileValidation Specifies whether log file integrity validation is enabled. The default
#' is false.
#' 
#' When you disable log file integrity validation, the chain of digest
#' files is broken after one hour. CloudTrail does not create digest files
#' for log files that were delivered during a period in which log file
#' integrity validation was disabled. For example, if you enable log file
#' integrity validation at noon on January 1, disable it at noon on January
#' 2, and re-enable it at noon on January 10, digest files will not be
#' created for the log files delivered from noon on January 2 to noon on
#' January 10. The same applies whenever you stop CloudTrail logging or
#' delete a trail.
#' @param CloudWatchLogsLogGroupArn Specifies a log group name using an Amazon Resource Name (ARN), a unique
#' identifier that represents the log group to which CloudTrail logs will
#' be delivered. You must use a log group that exists in your account.
#' 
#' Not required unless you specify `CloudWatchLogsRoleArn`.
#' @param CloudWatchLogsRoleArn Specifies the role for the CloudWatch Logs endpoint to assume to write
#' to a user's log group. You must use a role that exists in your account.
#' @param KmsKeyId Specifies the KMS key ID to use to encrypt the logs delivered by
#' CloudTrail. The value can be an alias name prefixed by `alias/`, a fully
#' specified ARN to an alias, a fully specified ARN to a key, or a globally
#' unique identifier.
#' 
#' CloudTrail also supports KMS multi-Region keys. For more information
#' about multi-Region keys, see [Using multi-Region
#' keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
#' in the *Key Management Service Developer Guide*.
#' 
#' Examples:
#' 
#' -   `alias/MyAliasName`
#' 
#' -   `arn:aws:kms:us-east-2:123456789012:alias/MyAliasName`
#' 
#' -   `arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012`
#' 
#' -   `12345678-1234-1234-1234-123456789012`
#' @param IsOrganizationTrail Specifies whether the trail is created for all accounts in an
#' organization in Organizations, or only for the current Amazon Web
#' Services account. The default is false, and cannot be true unless the
#' call is made on behalf of an Amazon Web Services account that is the
#' management account or delegated administrator account for an
#' organization in Organizations.
#' @param TagsList 
#'
#' @keywords internal
#'
#' @rdname cloudtrail_create_trail
cloudtrail_create_trail <- function(Name, S3BucketName, S3KeyPrefix = NULL, SnsTopicName = NULL, IncludeGlobalServiceEvents = NULL, IsMultiRegionTrail = NULL, EnableLogFileValidation = NULL, CloudWatchLogsLogGroupArn = NULL, CloudWatchLogsRoleArn = NULL, KmsKeyId = NULL, IsOrganizationTrail = NULL, TagsList = NULL) {
  op <- new_operation(
    name = "CreateTrail",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$create_trail_input(Name = Name, S3BucketName = S3BucketName, S3KeyPrefix = S3KeyPrefix, SnsTopicName = SnsTopicName, IncludeGlobalServiceEvents = IncludeGlobalServiceEvents, IsMultiRegionTrail = IsMultiRegionTrail, EnableLogFileValidation = EnableLogFileValidation, CloudWatchLogsLogGroupArn = CloudWatchLogsLogGroupArn, CloudWatchLogsRoleArn = CloudWatchLogsRoleArn, KmsKeyId = KmsKeyId, IsOrganizationTrail = IsOrganizationTrail, TagsList = TagsList)
  output <- .cloudtrail$create_trail_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$create_trail <- cloudtrail_create_trail

#' Deletes a channel
#'
#' @description
#' Deletes a channel.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_delete_channel/](https://www.paws-r-sdk.com/docs/cloudtrail_delete_channel/) for full documentation.
#'
#' @param Channel &#91;required&#93; The ARN or the `UUID` value of the channel that you want to delete.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_delete_channel
cloudtrail_delete_channel <- function(Channel) {
  op <- new_operation(
    name = "DeleteChannel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$delete_channel_input(Channel = Channel)
  output <- .cloudtrail$delete_channel_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$delete_channel <- cloudtrail_delete_channel

#' Deletes the specified dashboard
#'
#' @description
#' Deletes the specified dashboard. You cannot delete a dashboard that has termination protection enabled.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_delete_dashboard/](https://www.paws-r-sdk.com/docs/cloudtrail_delete_dashboard/) for full documentation.
#'
#' @param DashboardId &#91;required&#93; The name or ARN for the dashboard.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_delete_dashboard
cloudtrail_delete_dashboard <- function(DashboardId) {
  op <- new_operation(
    name = "DeleteDashboard",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$delete_dashboard_input(DashboardId = DashboardId)
  output <- .cloudtrail$delete_dashboard_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$delete_dashboard <- cloudtrail_delete_dashboard

#' Disables the event data store specified by EventDataStore, which accepts
#' an event data store ARN
#'
#' @description
#' Disables the event data store specified by `EventDataStore`, which accepts an event data store ARN. After you run [`delete_event_data_store`][cloudtrail_delete_event_data_store], the event data store enters a `PENDING_DELETION` state, and is automatically deleted after a wait period of seven days. `TerminationProtectionEnabled` must be set to `False` on the event data store and the `FederationStatus` must be `DISABLED`. You cannot delete an event data store if `TerminationProtectionEnabled` is `True` or the `FederationStatus` is `ENABLED`.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_delete_event_data_store/](https://www.paws-r-sdk.com/docs/cloudtrail_delete_event_data_store/) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or the ID suffix of the ARN) of the event data store to delete.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_delete_event_data_store
cloudtrail_delete_event_data_store <- function(EventDataStore) {
  op <- new_operation(
    name = "DeleteEventDataStore",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$delete_event_data_store_input(EventDataStore = EventDataStore)
  output <- .cloudtrail$delete_event_data_store_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$delete_event_data_store <- cloudtrail_delete_event_data_store

#' Deletes the resource-based policy attached to the CloudTrail event data
#' store, dashboard, or channel
#'
#' @description
#' Deletes the resource-based policy attached to the CloudTrail event data store, dashboard, or channel.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_delete_resource_policy/](https://www.paws-r-sdk.com/docs/cloudtrail_delete_resource_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the CloudTrail event data store,
#' dashboard, or channel you're deleting the resource-based policy from.
#' 
#' Example event data store ARN format:
#' `arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
#' 
#' Example dashboard ARN format:
#' `arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash`
#' 
#' Example channel ARN format:
#' `arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890`
#'
#' @keywords internal
#'
#' @rdname cloudtrail_delete_resource_policy
cloudtrail_delete_resource_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$delete_resource_policy_input(ResourceArn = ResourceArn)
  output <- .cloudtrail$delete_resource_policy_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$delete_resource_policy <- cloudtrail_delete_resource_policy

#' Deletes a trail
#'
#' @description
#' Deletes a trail. This operation must be called from the Region in which the trail was created. [`delete_trail`][cloudtrail_delete_trail] cannot be called on the shadow trails (replicated trails in other Regions) of a trail that is enabled in all Regions.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_delete_trail/](https://www.paws-r-sdk.com/docs/cloudtrail_delete_trail/) for full documentation.
#'
#' @param Name &#91;required&#93; Specifies the name or the CloudTrail ARN of the trail to be deleted. The
#' following is the format of a trail ARN.
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @keywords internal
#'
#' @rdname cloudtrail_delete_trail
cloudtrail_delete_trail <- function(Name) {
  op <- new_operation(
    name = "DeleteTrail",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$delete_trail_input(Name = Name)
  output <- .cloudtrail$delete_trail_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$delete_trail <- cloudtrail_delete_trail

#' Removes CloudTrail delegated administrator permissions from a member
#' account in an organization
#'
#' @description
#' Removes CloudTrail delegated administrator permissions from a member account in an organization.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_deregister_organization_delegated_admin/](https://www.paws-r-sdk.com/docs/cloudtrail_deregister_organization_delegated_admin/) for full documentation.
#'
#' @param DelegatedAdminAccountId &#91;required&#93; A delegated administrator account ID. This is a member account in an
#' organization that is currently designated as a delegated administrator.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_deregister_organization_delegated_admin
cloudtrail_deregister_organization_delegated_admin <- function(DelegatedAdminAccountId) {
  op <- new_operation(
    name = "DeregisterOrganizationDelegatedAdmin",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$deregister_organization_delegated_admin_input(DelegatedAdminAccountId = DelegatedAdminAccountId)
  output <- .cloudtrail$deregister_organization_delegated_admin_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$deregister_organization_delegated_admin <- cloudtrail_deregister_organization_delegated_admin

#' Returns metadata about a query, including query run time in
#' milliseconds, number of events scanned and matched, and query status
#'
#' @description
#' Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched, and query status. If the query results were delivered to an S3 bucket, the response also provides the S3 URI and the delivery status.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_describe_query/](https://www.paws-r-sdk.com/docs/cloudtrail_describe_query/) for full documentation.
#'
#' @param EventDataStore The ARN (or the ID suffix of the ARN) of an event data store on which
#' the specified query was run.
#' @param QueryId The query ID.
#' @param QueryAlias The alias that identifies a query template.
#' @param RefreshId The ID of the dashboard refresh.
#' @param EventDataStoreOwnerAccountId The account ID of the event data store owner.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_describe_query
cloudtrail_describe_query <- function(EventDataStore = NULL, QueryId = NULL, QueryAlias = NULL, RefreshId = NULL, EventDataStoreOwnerAccountId = NULL) {
  op <- new_operation(
    name = "DescribeQuery",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$describe_query_input(EventDataStore = EventDataStore, QueryId = QueryId, QueryAlias = QueryAlias, RefreshId = RefreshId, EventDataStoreOwnerAccountId = EventDataStoreOwnerAccountId)
  output <- .cloudtrail$describe_query_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$describe_query <- cloudtrail_describe_query

#' Retrieves settings for one or more trails associated with the current
#' Region for your account
#'
#' @description
#' Retrieves settings for one or more trails associated with the current Region for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_describe_trails/](https://www.paws-r-sdk.com/docs/cloudtrail_describe_trails/) for full documentation.
#'
#' @param trailNameList Specifies a list of trail names, trail ARNs, or both, of the trails to
#' describe. The format of a trail ARN is:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' 
#' If an empty list is specified, information for the trail in the current
#' Region is returned.
#' 
#' -   If an empty list is specified and `IncludeShadowTrails` is false,
#'     then information for all trails in the current Region is returned.
#' 
#' -   If an empty list is specified and IncludeShadowTrails is null or
#'     true, then information for all trails in the current Region and any
#'     associated shadow trails in other Regions is returned.
#' 
#' If one or more trail names are specified, information is returned only
#' if the names match the names of trails belonging only to the current
#' Region and current account. To return information about a trail in
#' another Region, you must specify its trail ARN.
#' @param includeShadowTrails Specifies whether to include shadow trails in the response. A shadow
#' trail is the replication in a Region of a trail that was created in a
#' different Region, or in the case of an organization trail, the
#' replication of an organization trail in member accounts. If you do not
#' include shadow trails, organization trails in a member account and
#' Region replication trails will not be returned. The default is true.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_describe_trails
cloudtrail_describe_trails <- function(trailNameList = NULL, includeShadowTrails = NULL) {
  op <- new_operation(
    name = "DescribeTrails",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$describe_trails_input(trailNameList = trailNameList, includeShadowTrails = includeShadowTrails)
  output <- .cloudtrail$describe_trails_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$describe_trails <- cloudtrail_describe_trails

#' Disables Lake query federation on the specified event data store
#'
#' @description
#' Disables Lake query federation on the specified event data store. When you disable federation, CloudTrail disables the integration with Glue, Lake Formation, and Amazon Athena. After disabling Lake query federation, you can no longer query your event data in Amazon Athena.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_disable_federation/](https://www.paws-r-sdk.com/docs/cloudtrail_disable_federation/) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or ID suffix of the ARN) of the event data store for which you
#' want to disable Lake query federation.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_disable_federation
cloudtrail_disable_federation <- function(EventDataStore) {
  op <- new_operation(
    name = "DisableFederation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$disable_federation_input(EventDataStore = EventDataStore)
  output <- .cloudtrail$disable_federation_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$disable_federation <- cloudtrail_disable_federation

#' Enables Lake query federation on the specified event data store
#'
#' @description
#' Enables Lake query federation on the specified event data store. Federating an event data store lets you view the metadata associated with the event data store in the Glue [Data Catalog](https://docs.aws.amazon.com/glue/latest/dg/components-overview.html#data-catalog-intro) and run SQL queries against your event data using Amazon Athena. The table metadata stored in the Glue Data Catalog lets the Athena query engine know how to find, read, and process the data that you want to query.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_enable_federation/](https://www.paws-r-sdk.com/docs/cloudtrail_enable_federation/) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or ID suffix of the ARN) of the event data store for which you
#' want to enable Lake query federation.
#' @param FederationRoleArn &#91;required&#93; The ARN of the federation role to use for the event data store. Amazon
#' Web Services services like Lake Formation use this federation role to
#' access data for the federated event data store. The federation role must
#' exist in your account and provide the [required minimum
#' permissions](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html#query-federation-permissions-role).
#'
#' @keywords internal
#'
#' @rdname cloudtrail_enable_federation
cloudtrail_enable_federation <- function(EventDataStore, FederationRoleArn) {
  op <- new_operation(
    name = "EnableFederation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$enable_federation_input(EventDataStore = EventDataStore, FederationRoleArn = FederationRoleArn)
  output <- .cloudtrail$enable_federation_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$enable_federation <- cloudtrail_enable_federation

#' Generates a query from a natural language prompt
#'
#' @description
#' Generates a query from a natural language prompt. This operation uses generative artificial intelligence (generative AI) to produce a ready-to-use SQL query from the prompt.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_generate_query/](https://www.paws-r-sdk.com/docs/cloudtrail_generate_query/) for full documentation.
#'
#' @param EventDataStores &#91;required&#93; The ARN (or ID suffix of the ARN) of the event data store that you want
#' to query. You can only specify one event data store.
#' @param Prompt &#91;required&#93; The prompt that you want to use to generate the query. The prompt must
#' be in English. For example prompts, see [Example
#' prompts](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-query-generator.html#lake-query-generator-examples)
#' in the *CloudTrail* user guide.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_generate_query
cloudtrail_generate_query <- function(EventDataStores, Prompt) {
  op <- new_operation(
    name = "GenerateQuery",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$generate_query_input(EventDataStores = EventDataStores, Prompt = Prompt)
  output <- .cloudtrail$generate_query_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$generate_query <- cloudtrail_generate_query

#' Returns information about a specific channel
#'
#' @description
#' Returns information about a specific channel.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_get_channel/](https://www.paws-r-sdk.com/docs/cloudtrail_get_channel/) for full documentation.
#'
#' @param Channel &#91;required&#93; The ARN or `UUID` of a channel.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_channel
cloudtrail_get_channel <- function(Channel) {
  op <- new_operation(
    name = "GetChannel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$get_channel_input(Channel = Channel)
  output <- .cloudtrail$get_channel_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_channel <- cloudtrail_get_channel

#' Returns the specified dashboard
#'
#' @description
#' Returns the specified dashboard.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_get_dashboard/](https://www.paws-r-sdk.com/docs/cloudtrail_get_dashboard/) for full documentation.
#'
#' @param DashboardId &#91;required&#93; The name or ARN for the dashboard.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_dashboard
cloudtrail_get_dashboard <- function(DashboardId) {
  op <- new_operation(
    name = "GetDashboard",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$get_dashboard_input(DashboardId = DashboardId)
  output <- .cloudtrail$get_dashboard_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_dashboard <- cloudtrail_get_dashboard

#' Returns information about an event data store specified as either an ARN
#' or the ID portion of the ARN
#'
#' @description
#' Returns information about an event data store specified as either an ARN or the ID portion of the ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_get_event_data_store/](https://www.paws-r-sdk.com/docs/cloudtrail_get_event_data_store/) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or ID suffix of the ARN) of the event data store about which
#' you want information.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_event_data_store
cloudtrail_get_event_data_store <- function(EventDataStore) {
  op <- new_operation(
    name = "GetEventDataStore",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$get_event_data_store_input(EventDataStore = EventDataStore)
  output <- .cloudtrail$get_event_data_store_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_event_data_store <- cloudtrail_get_event_data_store

#' Describes the settings for the event selectors that you configured for
#' your trail
#'
#' @description
#' Describes the settings for the event selectors that you configured for your trail. The information returned for your event selectors includes the following:
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_get_event_selectors/](https://www.paws-r-sdk.com/docs/cloudtrail_get_event_selectors/) for full documentation.
#'
#' @param TrailName &#91;required&#93; Specifies the name of the trail or trail ARN. If you specify a trail
#' name, the string must meet the following requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are not valid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' 
#' If you specify a trail ARN, it must be in the format:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_event_selectors
cloudtrail_get_event_selectors <- function(TrailName) {
  op <- new_operation(
    name = "GetEventSelectors",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$get_event_selectors_input(TrailName = TrailName)
  output <- .cloudtrail$get_event_selectors_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_event_selectors <- cloudtrail_get_event_selectors

#' Returns information about a specific import
#'
#' @description
#' Returns information about a specific import.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_get_import/](https://www.paws-r-sdk.com/docs/cloudtrail_get_import/) for full documentation.
#'
#' @param ImportId &#91;required&#93; The ID for the import.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_import
cloudtrail_get_import <- function(ImportId) {
  op <- new_operation(
    name = "GetImport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$get_import_input(ImportId = ImportId)
  output <- .cloudtrail$get_import_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_import <- cloudtrail_get_import

#' Describes the settings for the Insights event selectors that you
#' configured for your trail or event data store
#'
#' @description
#' Describes the settings for the Insights event selectors that you configured for your trail or event data store. [`get_insight_selectors`][cloudtrail_get_insight_selectors] shows if CloudTrail Insights event logging is enabled on the trail or event data store, and if it is, which Insights types are enabled. If you run [`get_insight_selectors`][cloudtrail_get_insight_selectors] on a trail or event data store that does not have Insights events enabled, the operation throws the exception `InsightNotEnabledException`
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_get_insight_selectors/](https://www.paws-r-sdk.com/docs/cloudtrail_get_insight_selectors/) for full documentation.
#'
#' @param TrailName Specifies the name of the trail or trail ARN. If you specify a trail
#' name, the string must meet the following requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are not valid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' 
#' If you specify a trail ARN, it must be in the format:
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' 
#' You cannot use this parameter with the `EventDataStore` parameter.
#' @param EventDataStore Specifies the ARN (or ID suffix of the ARN) of the event data store for
#' which you want to get Insights selectors.
#' 
#' You cannot use this parameter with the `TrailName` parameter.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_insight_selectors
cloudtrail_get_insight_selectors <- function(TrailName = NULL, EventDataStore = NULL) {
  op <- new_operation(
    name = "GetInsightSelectors",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$get_insight_selectors_input(TrailName = TrailName, EventDataStore = EventDataStore)
  output <- .cloudtrail$get_insight_selectors_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_insight_selectors <- cloudtrail_get_insight_selectors

#' Gets event data results of a query
#'
#' @description
#' Gets event data results of a query. You must specify the `QueryID` value returned by the [`start_query`][cloudtrail_start_query] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_get_query_results/](https://www.paws-r-sdk.com/docs/cloudtrail_get_query_results/) for full documentation.
#'
#' @param EventDataStore The ARN (or ID suffix of the ARN) of the event data store against which
#' the query was run.
#' @param QueryId &#91;required&#93; The ID of the query for which you want to get results.
#' @param NextToken A token you can use to get the next page of query results.
#' @param MaxQueryResults The maximum number of query results to display on a single page.
#' @param EventDataStoreOwnerAccountId The account ID of the event data store owner.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_query_results
cloudtrail_get_query_results <- function(EventDataStore = NULL, QueryId, NextToken = NULL, MaxQueryResults = NULL, EventDataStoreOwnerAccountId = NULL) {
  op <- new_operation(
    name = "GetQueryResults",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken"),
    stream_api = FALSE
  )
  input <- .cloudtrail$get_query_results_input(EventDataStore = EventDataStore, QueryId = QueryId, NextToken = NextToken, MaxQueryResults = MaxQueryResults, EventDataStoreOwnerAccountId = EventDataStoreOwnerAccountId)
  output <- .cloudtrail$get_query_results_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_query_results <- cloudtrail_get_query_results

#' Retrieves the JSON text of the resource-based policy document attached
#' to the CloudTrail event data store, dashboard, or channel
#'
#' @description
#' Retrieves the JSON text of the resource-based policy document attached to the CloudTrail event data store, dashboard, or channel.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_get_resource_policy/](https://www.paws-r-sdk.com/docs/cloudtrail_get_resource_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the CloudTrail event data store,
#' dashboard, or channel attached to the resource-based policy.
#' 
#' Example event data store ARN format:
#' `arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
#' 
#' Example dashboard ARN format:
#' `arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash`
#' 
#' Example channel ARN format:
#' `arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890`
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_resource_policy
cloudtrail_get_resource_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "GetResourcePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$get_resource_policy_input(ResourceArn = ResourceArn)
  output <- .cloudtrail$get_resource_policy_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_resource_policy <- cloudtrail_get_resource_policy

#' Returns settings information for a specified trail
#'
#' @description
#' Returns settings information for a specified trail.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_get_trail/](https://www.paws-r-sdk.com/docs/cloudtrail_get_trail/) for full documentation.
#'
#' @param Name &#91;required&#93; The name or the Amazon Resource Name (ARN) of the trail for which you
#' want to retrieve settings information.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_trail
cloudtrail_get_trail <- function(Name) {
  op <- new_operation(
    name = "GetTrail",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$get_trail_input(Name = Name)
  output <- .cloudtrail$get_trail_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_trail <- cloudtrail_get_trail

#' Returns a JSON-formatted list of information about the specified trail
#'
#' @description
#' Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns trail status from a single Region. To return trail status from all Regions, you must call the operation on each Region.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_get_trail_status/](https://www.paws-r-sdk.com/docs/cloudtrail_get_trail_status/) for full documentation.
#'
#' @param Name &#91;required&#93; Specifies the name or the CloudTrail ARN of the trail for which you are
#' requesting status. To get the status of a shadow trail (a replication of
#' the trail in another Region), you must specify its ARN.
#' 
#' The following is the format of a trail ARN:
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' 
#' If the trail is an organization trail and you are a member account in
#' the organization in Organizations, you must provide the full ARN of that
#' trail, and not just the name.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_get_trail_status
cloudtrail_get_trail_status <- function(Name) {
  op <- new_operation(
    name = "GetTrailStatus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$get_trail_status_input(Name = Name)
  output <- .cloudtrail$get_trail_status_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$get_trail_status <- cloudtrail_get_trail_status

#' Lists the channels in the current account, and their source names
#'
#' @description
#' Lists the channels in the current account, and their source names.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_list_channels/](https://www.paws-r-sdk.com/docs/cloudtrail_list_channels/) for full documentation.
#'
#' @param MaxResults The maximum number of CloudTrail channels to display on a single page.
#' @param NextToken The token to use to get the next page of results after a previous API
#' call. This token must be passed in with the same parameters that were
#' specified in the original call. For example, if the original call
#' specified an AttributeKey of 'Username' with a value of 'root', the call
#' with NextToken should include those same parameters.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_channels
cloudtrail_list_channels <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListChannels",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken"),
    stream_api = FALSE
  )
  input <- .cloudtrail$list_channels_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudtrail$list_channels_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_channels <- cloudtrail_list_channels

#' Returns information about all dashboards in the account, in the current
#' Region
#'
#' @description
#' Returns information about all dashboards in the account, in the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_list_dashboards/](https://www.paws-r-sdk.com/docs/cloudtrail_list_dashboards/) for full documentation.
#'
#' @param NamePrefix Specify a name prefix to filter on.
#' @param Type Specify a dashboard type to filter on: `CUSTOM` or `MANAGED`.
#' @param NextToken A token you can use to get the next page of dashboard results.
#' @param MaxResults The maximum number of dashboards to display on a single page.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_dashboards
cloudtrail_list_dashboards <- function(NamePrefix = NULL, Type = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDashboards",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$list_dashboards_input(NamePrefix = NamePrefix, Type = Type, NextToken = NextToken, MaxResults = MaxResults)
  output <- .cloudtrail$list_dashboards_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_dashboards <- cloudtrail_list_dashboards

#' Returns information about all event data stores in the account, in the
#' current Region
#'
#' @description
#' Returns information about all event data stores in the account, in the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_list_event_data_stores/](https://www.paws-r-sdk.com/docs/cloudtrail_list_event_data_stores/) for full documentation.
#'
#' @param NextToken A token you can use to get the next page of event data store results.
#' @param MaxResults The maximum number of event data stores to display on a single page.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_event_data_stores
cloudtrail_list_event_data_stores <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEventDataStores",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken"),
    stream_api = FALSE
  )
  input <- .cloudtrail$list_event_data_stores_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .cloudtrail$list_event_data_stores_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_event_data_stores <- cloudtrail_list_event_data_stores

#' Returns a list of failures for the specified import
#'
#' @description
#' Returns a list of failures for the specified import.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_list_import_failures/](https://www.paws-r-sdk.com/docs/cloudtrail_list_import_failures/) for full documentation.
#'
#' @param ImportId &#91;required&#93; The ID of the import.
#' @param MaxResults The maximum number of failures to display on a single page.
#' @param NextToken A token you can use to get the next page of import failures.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_import_failures
cloudtrail_list_import_failures <- function(ImportId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListImportFailures",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Failures"),
    stream_api = FALSE
  )
  input <- .cloudtrail$list_import_failures_input(ImportId = ImportId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudtrail$list_import_failures_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_import_failures <- cloudtrail_list_import_failures

#' Returns information on all imports, or a select set of imports by
#' ImportStatus or Destination
#'
#' @description
#' Returns information on all imports, or a select set of imports by `ImportStatus` or `Destination`.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_list_imports/](https://www.paws-r-sdk.com/docs/cloudtrail_list_imports/) for full documentation.
#'
#' @param MaxResults The maximum number of imports to display on a single page.
#' @param Destination The ARN of the destination event data store.
#' @param ImportStatus The status of the import.
#' @param NextToken A token you can use to get the next page of import results.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_imports
cloudtrail_list_imports <- function(MaxResults = NULL, Destination = NULL, ImportStatus = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListImports",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Imports"),
    stream_api = FALSE
  )
  input <- .cloudtrail$list_imports_input(MaxResults = MaxResults, Destination = Destination, ImportStatus = ImportStatus, NextToken = NextToken)
  output <- .cloudtrail$list_imports_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_imports <- cloudtrail_list_imports

#' Returns Insights metrics data for trails that have enabled Insights
#'
#' @description
#' Returns Insights metrics data for trails that have enabled Insights. The request must include the `EventSource`, `EventName`, and `InsightType` parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_list_insights_metric_data/](https://www.paws-r-sdk.com/docs/cloudtrail_list_insights_metric_data/) for full documentation.
#'
#' @param EventSource &#91;required&#93; The Amazon Web Services service to which the request was made, such as
#' `iam.amazonaws.com` or `s3.amazonaws.com`.
#' @param EventName &#91;required&#93; The name of the event, typically the Amazon Web Services API on which
#' unusual levels of activity were recorded.
#' @param InsightType &#91;required&#93; The type of CloudTrail Insights event, which is either
#' `ApiCallRateInsight` or `ApiErrorRateInsight`. The `ApiCallRateInsight`
#' Insights type analyzes write-only management API calls that are
#' aggregated per minute against a baseline API call volume. The
#' `ApiErrorRateInsight` Insights type analyzes management API calls that
#' result in error codes.
#' @param ErrorCode Conditionally required if the `InsightType` parameter is set to
#' `ApiErrorRateInsight`.
#' 
#' If returning metrics for the `ApiErrorRateInsight` Insights type, this
#' is the error to retrieve data for. For example, `AccessDenied`.
#' @param StartTime Specifies, in UTC, the start time for time-series data. The value
#' specified is inclusive; results include data points with the specified
#' time stamp.
#' 
#' The default is 90 days before the time of request.
#' @param EndTime Specifies, in UTC, the end time for time-series data. The value
#' specified is exclusive; results include data points up to the specified
#' time stamp.
#' 
#' The default is the time of request.
#' @param Period Granularity of data to retrieve, in seconds. Valid values are `60`,
#' `300`, and `3600`. If you specify any other value, you will get an
#' error. The default is 3600 seconds.
#' @param DataType Type of data points to return. Valid values are `NonZeroData` and
#' `FillWithZeros`. The default is `NonZeroData`.
#' @param MaxResults The maximum number of data points to return. Valid values are integers
#' from 1 to 21600. The default value is 21600.
#' @param NextToken Returned if all datapoints can't be returned in a single call. For
#' example, due to reaching `MaxResults`.
#' 
#' Add this parameter to the request to continue retrieving results
#' starting from the last evaluated point.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_insights_metric_data
cloudtrail_list_insights_metric_data <- function(EventSource, EventName, InsightType, ErrorCode = NULL, StartTime = NULL, EndTime = NULL, Period = NULL, DataType = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListInsightsMetricData",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken"),
    stream_api = FALSE
  )
  input <- .cloudtrail$list_insights_metric_data_input(EventSource = EventSource, EventName = EventName, InsightType = InsightType, ErrorCode = ErrorCode, StartTime = StartTime, EndTime = EndTime, Period = Period, DataType = DataType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudtrail$list_insights_metric_data_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_insights_metric_data <- cloudtrail_list_insights_metric_data

#' Returns all public keys whose private keys were used to sign the digest
#' files within the specified time range
#'
#' @description
#' Returns all public keys whose private keys were used to sign the digest files within the specified time range. The public key is needed to validate digest files that were signed with its corresponding private key.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_list_public_keys/](https://www.paws-r-sdk.com/docs/cloudtrail_list_public_keys/) for full documentation.
#'
#' @param StartTime Optionally specifies, in UTC, the start of the time range to look up
#' public keys for CloudTrail digest files. If not specified, the current
#' time is used, and the current public key is returned.
#' @param EndTime Optionally specifies, in UTC, the end of the time range to look up
#' public keys for CloudTrail digest files. If not specified, the current
#' time is used.
#' @param NextToken Reserved for future use.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_public_keys
cloudtrail_list_public_keys <- function(StartTime = NULL, EndTime = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPublicKeys",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "PublicKeyList"),
    stream_api = FALSE
  )
  input <- .cloudtrail$list_public_keys_input(StartTime = StartTime, EndTime = EndTime, NextToken = NextToken)
  output <- .cloudtrail$list_public_keys_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_public_keys <- cloudtrail_list_public_keys

#' Returns a list of queries and query statuses for the past seven days
#'
#' @description
#' Returns a list of queries and query statuses for the past seven days. You must specify an ARN value for `EventDataStore`. Optionally, to shorten the list of results, you can specify a time range, formatted as timestamps, by adding `StartTime` and `EndTime` parameters, and a `QueryStatus` value. Valid values for `QueryStatus` include `QUEUED`, `RUNNING`, `FINISHED`, `FAILED`, `TIMED_OUT`, or `CANCELLED`.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_list_queries/](https://www.paws-r-sdk.com/docs/cloudtrail_list_queries/) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or the ID suffix of the ARN) of an event data store on which
#' queries were run.
#' @param NextToken A token you can use to get the next page of results.
#' @param MaxResults The maximum number of queries to show on a page.
#' @param StartTime Use with `EndTime` to bound a [`list_queries`][cloudtrail_list_queries]
#' request, and limit its results to only those queries run within a
#' specified time period.
#' @param EndTime Use with `StartTime` to bound a
#' [`list_queries`][cloudtrail_list_queries] request, and limit its results
#' to only those queries run within a specified time period.
#' @param QueryStatus The status of queries that you want to return in results. Valid values
#' for `QueryStatus` include `QUEUED`, `RUNNING`, `FINISHED`, `FAILED`,
#' `TIMED_OUT`, or `CANCELLED`.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_queries
cloudtrail_list_queries <- function(EventDataStore, NextToken = NULL, MaxResults = NULL, StartTime = NULL, EndTime = NULL, QueryStatus = NULL) {
  op <- new_operation(
    name = "ListQueries",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken"),
    stream_api = FALSE
  )
  input <- .cloudtrail$list_queries_input(EventDataStore = EventDataStore, NextToken = NextToken, MaxResults = MaxResults, StartTime = StartTime, EndTime = EndTime, QueryStatus = QueryStatus)
  output <- .cloudtrail$list_queries_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_queries <- cloudtrail_list_queries

#' Lists the tags for the specified trails, event data stores, dashboards,
#' or channels in the current Region
#'
#' @description
#' Lists the tags for the specified trails, event data stores, dashboards, or channels in the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_list_tags/](https://www.paws-r-sdk.com/docs/cloudtrail_list_tags/) for full documentation.
#'
#' @param ResourceIdList &#91;required&#93; Specifies a list of trail, event data store, dashboard, or channel ARNs
#' whose tags will be listed. The list has a limit of 20 ARNs.
#' 
#' Example trail ARN format:
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' 
#' Example event data store ARN format:
#' `arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
#' 
#' Example dashboard ARN format:
#' `arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash`
#' 
#' Example channel ARN format:
#' `arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890`
#' @param NextToken Reserved for future use.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_tags
cloudtrail_list_tags <- function(ResourceIdList, NextToken = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "ResourceTagList"),
    stream_api = FALSE
  )
  input <- .cloudtrail$list_tags_input(ResourceIdList = ResourceIdList, NextToken = NextToken)
  output <- .cloudtrail$list_tags_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_tags <- cloudtrail_list_tags

#' Lists trails that are in the current account
#'
#' @description
#' Lists trails that are in the current account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_list_trails/](https://www.paws-r-sdk.com/docs/cloudtrail_list_trails/) for full documentation.
#'
#' @param NextToken The token to use to get the next page of results after a previous API
#' call. This token must be passed in with the same parameters that were
#' specified in the original call. For example, if the original call
#' specified an AttributeKey of 'Username' with a value of 'root', the call
#' with NextToken should include those same parameters.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_list_trails
cloudtrail_list_trails <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListTrails",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Trails"),
    stream_api = FALSE
  )
  input <- .cloudtrail$list_trails_input(NextToken = NextToken)
  output <- .cloudtrail$list_trails_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$list_trails <- cloudtrail_list_trails

#' Looks up management events or CloudTrail Insights events that are
#' captured by CloudTrail
#'
#' @description
#' Looks up [management events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events) or [CloudTrail Insights events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events) that are captured by CloudTrail. You can look up events that occurred in a Region within the last 90 days.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_lookup_events/](https://www.paws-r-sdk.com/docs/cloudtrail_lookup_events/) for full documentation.
#'
#' @param LookupAttributes Contains a list of lookup attributes. Currently the list can contain
#' only one item.
#' @param StartTime Specifies that only events that occur after or at the specified time are
#' returned. If the specified start time is after the specified end time,
#' an error is returned.
#' @param EndTime Specifies that only events that occur before or at the specified time
#' are returned. If the specified end time is before the specified start
#' time, an error is returned.
#' @param EventCategory Specifies the event category. If you do not specify an event category,
#' events of the category are not returned in the response. For example, if
#' you do not specify `insight` as the value of `EventCategory`, no
#' Insights events are returned.
#' @param MaxResults The number of events to return. Possible values are 1 through 50. The
#' default is 50.
#' @param NextToken The token to use to get the next page of results after a previous API
#' call. This token must be passed in with the same parameters that were
#' specified in the original call. For example, if the original call
#' specified an AttributeKey of 'Username' with a value of 'root', the call
#' with NextToken should include those same parameters.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_lookup_events
cloudtrail_lookup_events <- function(LookupAttributes = NULL, StartTime = NULL, EndTime = NULL, EventCategory = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "LookupEvents",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Events"),
    stream_api = FALSE
  )
  input <- .cloudtrail$lookup_events_input(LookupAttributes = LookupAttributes, StartTime = StartTime, EndTime = EndTime, EventCategory = EventCategory, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudtrail$lookup_events_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$lookup_events <- cloudtrail_lookup_events

#' Configures event selectors (also referred to as basic event selectors)
#' or advanced event selectors for your trail
#'
#' @description
#' Configures event selectors (also referred to as *basic event selectors*) or advanced event selectors for your trail. You can use either `AdvancedEventSelectors` or `EventSelectors`, but not both. If you apply `AdvancedEventSelectors` to a trail, any existing `EventSelectors` are overwritten.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_put_event_selectors/](https://www.paws-r-sdk.com/docs/cloudtrail_put_event_selectors/) for full documentation.
#'
#' @param TrailName &#91;required&#93; Specifies the name of the trail or trail ARN. If you specify a trail
#' name, the string must meet the following requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are not valid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' 
#' If you specify a trail ARN, it must be in the following format.
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' @param EventSelectors Specifies the settings for your event selectors. You can use event
#' selectors to log management events and data events for the following
#' resource types:
#' 
#' -   `AWS::DynamoDB::Table`
#' 
#' -   `AWS::Lambda::Function`
#' 
#' -   `AWS::S3::Object`
#' 
#' You can't use event selectors to log network activity events.
#' 
#' You can configure up to five event selectors for a trail. You can use
#' either `EventSelectors` or `AdvancedEventSelectors` in a
#' [`put_event_selectors`][cloudtrail_put_event_selectors] request, but not
#' both. If you apply `EventSelectors` to a trail, any existing
#' `AdvancedEventSelectors` are overwritten.
#' @param AdvancedEventSelectors Specifies the settings for advanced event selectors. You can use
#' advanced event selectors to log management events, data events for all
#' resource types, and network activity events.
#' 
#' You can add advanced event selectors, and conditions for your advanced
#' event selectors, up to a maximum of 500 values for all conditions and
#' selectors on a trail. You can use either `AdvancedEventSelectors` or
#' `EventSelectors`, but not both. If you apply `AdvancedEventSelectors` to
#' a trail, any existing `EventSelectors` are overwritten. For more
#' information about advanced event selectors, see [Logging data
#' events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html)
#' and [Logging network activity
#' events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html)
#' in the *CloudTrail User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_put_event_selectors
cloudtrail_put_event_selectors <- function(TrailName, EventSelectors = NULL, AdvancedEventSelectors = NULL) {
  op <- new_operation(
    name = "PutEventSelectors",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$put_event_selectors_input(TrailName = TrailName, EventSelectors = EventSelectors, AdvancedEventSelectors = AdvancedEventSelectors)
  output <- .cloudtrail$put_event_selectors_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$put_event_selectors <- cloudtrail_put_event_selectors

#' Lets you enable Insights event logging by specifying the Insights
#' selectors that you want to enable on an existing trail or event data
#' store
#'
#' @description
#' Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an existing trail or event data store. You also use [`put_insight_selectors`][cloudtrail_put_insight_selectors] to turn off Insights event logging, by passing an empty list of Insights types. The valid Insights event types are `ApiErrorRateInsight` and `ApiCallRateInsight`.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_put_insight_selectors/](https://www.paws-r-sdk.com/docs/cloudtrail_put_insight_selectors/) for full documentation.
#'
#' @param TrailName The name of the CloudTrail trail for which you want to change or add
#' Insights selectors.
#' 
#' You cannot use this parameter with the `EventDataStore` and
#' `InsightsDestination` parameters.
#' @param InsightSelectors &#91;required&#93; A JSON string that contains the Insights types you want to log on a
#' trail or event data store. `ApiCallRateInsight` and
#' `ApiErrorRateInsight` are valid Insight types.
#' 
#' The `ApiCallRateInsight` Insights type analyzes write-only management
#' API calls that are aggregated per minute against a baseline API call
#' volume.
#' 
#' The `ApiErrorRateInsight` Insights type analyzes management API calls
#' that result in error codes. The error is shown if the API call is
#' unsuccessful.
#' @param EventDataStore The ARN (or ID suffix of the ARN) of the source event data store for
#' which you want to change or add Insights selectors. To enable Insights
#' on an event data store, you must provide both the `EventDataStore` and
#' `InsightsDestination` parameters.
#' 
#' You cannot use this parameter with the `TrailName` parameter.
#' @param InsightsDestination The ARN (or ID suffix of the ARN) of the destination event data store
#' that logs Insights events. To enable Insights on an event data store,
#' you must provide both the `EventDataStore` and `InsightsDestination`
#' parameters.
#' 
#' You cannot use this parameter with the `TrailName` parameter.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_put_insight_selectors
cloudtrail_put_insight_selectors <- function(TrailName = NULL, InsightSelectors, EventDataStore = NULL, InsightsDestination = NULL) {
  op <- new_operation(
    name = "PutInsightSelectors",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$put_insight_selectors_input(TrailName = TrailName, InsightSelectors = InsightSelectors, EventDataStore = EventDataStore, InsightsDestination = InsightsDestination)
  output <- .cloudtrail$put_insight_selectors_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$put_insight_selectors <- cloudtrail_put_insight_selectors

#' Attaches a resource-based permission policy to a CloudTrail event data
#' store, dashboard, or channel
#'
#' @description
#' Attaches a resource-based permission policy to a CloudTrail event data store, dashboard, or channel. For more information about resource-based policies, see [CloudTrail resource-based policy examples](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html) in the *CloudTrail User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_put_resource_policy/](https://www.paws-r-sdk.com/docs/cloudtrail_put_resource_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the CloudTrail event data store,
#' dashboard, or channel attached to the resource-based policy.
#' 
#' Example event data store ARN format:
#' `arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
#' 
#' Example dashboard ARN format:
#' `arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash`
#' 
#' Example channel ARN format:
#' `arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890`
#' @param ResourcePolicy &#91;required&#93; A JSON-formatted string for an Amazon Web Services resource-based
#' policy.
#' 
#' For example resource-based policies, see [CloudTrail resource-based
#' policy
#' examples](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html)
#' in the *CloudTrail User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_put_resource_policy
cloudtrail_put_resource_policy <- function(ResourceArn, ResourcePolicy) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$put_resource_policy_input(ResourceArn = ResourceArn, ResourcePolicy = ResourcePolicy)
  output <- .cloudtrail$put_resource_policy_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$put_resource_policy <- cloudtrail_put_resource_policy

#' Registers an organization’s member account as the CloudTrail delegated
#' administrator
#'
#' @description
#' Registers an organization’s member account as the CloudTrail [delegated administrator](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-delegated-administrator.html).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_register_organization_delegated_admin/](https://www.paws-r-sdk.com/docs/cloudtrail_register_organization_delegated_admin/) for full documentation.
#'
#' @param MemberAccountId &#91;required&#93; An organization member account ID that you want to designate as a
#' delegated administrator.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_register_organization_delegated_admin
cloudtrail_register_organization_delegated_admin <- function(MemberAccountId) {
  op <- new_operation(
    name = "RegisterOrganizationDelegatedAdmin",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$register_organization_delegated_admin_input(MemberAccountId = MemberAccountId)
  output <- .cloudtrail$register_organization_delegated_admin_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$register_organization_delegated_admin <- cloudtrail_register_organization_delegated_admin

#' Removes the specified tags from a trail, event data store, dashboard, or
#' channel
#'
#' @description
#' Removes the specified tags from a trail, event data store, dashboard, or channel.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_remove_tags/](https://www.paws-r-sdk.com/docs/cloudtrail_remove_tags/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; Specifies the ARN of the trail, event data store, dashboard, or channel
#' from which tags should be removed.
#' 
#' Example trail ARN format:
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' 
#' Example event data store ARN format:
#' `arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE`
#' 
#' Example dashboard ARN format:
#' `arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash`
#' 
#' Example channel ARN format:
#' `arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890`
#' @param TagsList &#91;required&#93; Specifies a list of tags to be removed.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_remove_tags
cloudtrail_remove_tags <- function(ResourceId, TagsList) {
  op <- new_operation(
    name = "RemoveTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$remove_tags_input(ResourceId = ResourceId, TagsList = TagsList)
  output <- .cloudtrail$remove_tags_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$remove_tags <- cloudtrail_remove_tags

#' Restores a deleted event data store specified by EventDataStore, which
#' accepts an event data store ARN
#'
#' @description
#' Restores a deleted event data store specified by `EventDataStore`, which accepts an event data store ARN. You can only restore a deleted event data store within the seven-day wait period after deletion. Restoring an event data store can take several minutes, depending on the size of the event data store.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_restore_event_data_store/](https://www.paws-r-sdk.com/docs/cloudtrail_restore_event_data_store/) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or the ID suffix of the ARN) of the event data store that you
#' want to restore.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_restore_event_data_store
cloudtrail_restore_event_data_store <- function(EventDataStore) {
  op <- new_operation(
    name = "RestoreEventDataStore",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$restore_event_data_store_input(EventDataStore = EventDataStore)
  output <- .cloudtrail$restore_event_data_store_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$restore_event_data_store <- cloudtrail_restore_event_data_store

#' Searches sample queries and returns a list of sample queries that are
#' sorted by relevance
#'
#' @description
#' Searches sample queries and returns a list of sample queries that are sorted by relevance. To search for sample queries, provide a natural language `SearchPhrase` in English.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_search_sample_queries/](https://www.paws-r-sdk.com/docs/cloudtrail_search_sample_queries/) for full documentation.
#'
#' @param SearchPhrase &#91;required&#93; The natural language phrase to use for the semantic search. The phrase
#' must be in English. The length constraint is in characters, not words.
#' @param MaxResults The maximum number of results to return on a single page. The default
#' value is 10.
#' @param NextToken A token you can use to get the next page of results. The length
#' constraint is in characters, not words.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_search_sample_queries
cloudtrail_search_sample_queries <- function(SearchPhrase, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "SearchSampleQueries",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$search_sample_queries_input(SearchPhrase = SearchPhrase, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudtrail$search_sample_queries_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$search_sample_queries <- cloudtrail_search_sample_queries

#' Starts a refresh of the specified dashboard
#'
#' @description
#' Starts a refresh of the specified dashboard.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_start_dashboard_refresh/](https://www.paws-r-sdk.com/docs/cloudtrail_start_dashboard_refresh/) for full documentation.
#'
#' @param DashboardId &#91;required&#93; The name or ARN of the dashboard.
#' @param QueryParameterValues The query parameter values for the dashboard
#' 
#' For custom dashboards, the following query parameters are valid:
#' `$StartTime$`, `$EndTime$`, and `$Period$`.
#' 
#' For managed dashboards, the following query parameters are valid:
#' `$StartTime$`, `$EndTime$`, `$Period$`, and `$EventDataStoreId$`. The
#' `$EventDataStoreId$` query parameter is required.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_start_dashboard_refresh
cloudtrail_start_dashboard_refresh <- function(DashboardId, QueryParameterValues = NULL) {
  op <- new_operation(
    name = "StartDashboardRefresh",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$start_dashboard_refresh_input(DashboardId = DashboardId, QueryParameterValues = QueryParameterValues)
  output <- .cloudtrail$start_dashboard_refresh_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$start_dashboard_refresh <- cloudtrail_start_dashboard_refresh

#' Starts the ingestion of live events on an event data store specified as
#' either an ARN or the ID portion of the ARN
#'
#' @description
#' Starts the ingestion of live events on an event data store specified as either an ARN or the ID portion of the ARN. To start ingestion, the event data store `Status` must be `STOPPED_INGESTION` and the `eventCategory` must be `Management`, `Data`, `NetworkActivity`, or `ConfigurationItem`.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_start_event_data_store_ingestion/](https://www.paws-r-sdk.com/docs/cloudtrail_start_event_data_store_ingestion/) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or ID suffix of the ARN) of the event data store for which you
#' want to start ingestion.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_start_event_data_store_ingestion
cloudtrail_start_event_data_store_ingestion <- function(EventDataStore) {
  op <- new_operation(
    name = "StartEventDataStoreIngestion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$start_event_data_store_ingestion_input(EventDataStore = EventDataStore)
  output <- .cloudtrail$start_event_data_store_ingestion_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$start_event_data_store_ingestion <- cloudtrail_start_event_data_store_ingestion

#' Starts an import of logged trail events from a source S3 bucket to a
#' destination event data store
#'
#' @description
#' Starts an import of logged trail events from a source S3 bucket to a destination event data store. By default, CloudTrail only imports events contained in the S3 bucket's `CloudTrail` prefix and the prefixes inside the `CloudTrail` prefix, and does not check prefixes for other Amazon Web Services services. If you want to import CloudTrail events contained in another prefix, you must include the prefix in the `S3LocationUri`. For more considerations about importing trail events, see [Considerations for copying trail events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-copy-trail-to-lake.html#cloudtrail-trail-copy-considerations) in the *CloudTrail User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_start_import/](https://www.paws-r-sdk.com/docs/cloudtrail_start_import/) for full documentation.
#'
#' @param Destinations The ARN of the destination event data store. Use this parameter for a
#' new import.
#' @param ImportSource The source S3 bucket for the import. Use this parameter for a new
#' import.
#' @param StartEventTime Use with `EndEventTime` to bound a
#' [`start_import`][cloudtrail_start_import] request, and limit imported
#' trail events to only those events logged within a specified time period.
#' When you specify a time range, CloudTrail checks the prefix and log file
#' names to verify the names contain a date between the specified
#' `StartEventTime` and `EndEventTime` before attempting to import events.
#' @param EndEventTime Use with `StartEventTime` to bound a
#' [`start_import`][cloudtrail_start_import] request, and limit imported
#' trail events to only those events logged within a specified time period.
#' When you specify a time range, CloudTrail checks the prefix and log file
#' names to verify the names contain a date between the specified
#' `StartEventTime` and `EndEventTime` before attempting to import events.
#' @param ImportId The ID of the import. Use this parameter when you are retrying an
#' import.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_start_import
cloudtrail_start_import <- function(Destinations = NULL, ImportSource = NULL, StartEventTime = NULL, EndEventTime = NULL, ImportId = NULL) {
  op <- new_operation(
    name = "StartImport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$start_import_input(Destinations = Destinations, ImportSource = ImportSource, StartEventTime = StartEventTime, EndEventTime = EndEventTime, ImportId = ImportId)
  output <- .cloudtrail$start_import_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$start_import <- cloudtrail_start_import

#' Starts the recording of Amazon Web Services API calls and log file
#' delivery for a trail
#'
#' @description
#' Starts the recording of Amazon Web Services API calls and log file delivery for a trail. For a trail that is enabled in all Regions, this operation must be called from the Region in which the trail was created. This operation cannot be called on the shadow trails (replicated trails in other Regions) of a trail that is enabled in all Regions.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_start_logging/](https://www.paws-r-sdk.com/docs/cloudtrail_start_logging/) for full documentation.
#'
#' @param Name &#91;required&#93; Specifies the name or the CloudTrail ARN of the trail for which
#' CloudTrail logs Amazon Web Services API calls. The following is the
#' format of a trail ARN.
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @keywords internal
#'
#' @rdname cloudtrail_start_logging
cloudtrail_start_logging <- function(Name) {
  op <- new_operation(
    name = "StartLogging",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$start_logging_input(Name = Name)
  output <- .cloudtrail$start_logging_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$start_logging <- cloudtrail_start_logging

#' Starts a CloudTrail Lake query
#'
#' @description
#' Starts a CloudTrail Lake query. Use the `QueryStatement` parameter to provide your SQL query, enclosed in single quotation marks. Use the optional `DeliveryS3Uri` parameter to deliver the query results to an S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_start_query/](https://www.paws-r-sdk.com/docs/cloudtrail_start_query/) for full documentation.
#'
#' @param QueryStatement The SQL code of your query.
#' @param DeliveryS3Uri The URI for the S3 bucket where CloudTrail delivers the query results.
#' @param QueryAlias The alias that identifies a query template.
#' @param QueryParameters The query parameters for the specified `QueryAlias`.
#' @param EventDataStoreOwnerAccountId The account ID of the event data store owner.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_start_query
cloudtrail_start_query <- function(QueryStatement = NULL, DeliveryS3Uri = NULL, QueryAlias = NULL, QueryParameters = NULL, EventDataStoreOwnerAccountId = NULL) {
  op <- new_operation(
    name = "StartQuery",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$start_query_input(QueryStatement = QueryStatement, DeliveryS3Uri = DeliveryS3Uri, QueryAlias = QueryAlias, QueryParameters = QueryParameters, EventDataStoreOwnerAccountId = EventDataStoreOwnerAccountId)
  output <- .cloudtrail$start_query_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$start_query <- cloudtrail_start_query

#' Stops the ingestion of live events on an event data store specified as
#' either an ARN or the ID portion of the ARN
#'
#' @description
#' Stops the ingestion of live events on an event data store specified as either an ARN or the ID portion of the ARN. To stop ingestion, the event data store `Status` must be `ENABLED` and the `eventCategory` must be `Management`, `Data`, `NetworkActivity`, or `ConfigurationItem`.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_stop_event_data_store_ingestion/](https://www.paws-r-sdk.com/docs/cloudtrail_stop_event_data_store_ingestion/) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or ID suffix of the ARN) of the event data store for which you
#' want to stop ingestion.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_stop_event_data_store_ingestion
cloudtrail_stop_event_data_store_ingestion <- function(EventDataStore) {
  op <- new_operation(
    name = "StopEventDataStoreIngestion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$stop_event_data_store_ingestion_input(EventDataStore = EventDataStore)
  output <- .cloudtrail$stop_event_data_store_ingestion_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$stop_event_data_store_ingestion <- cloudtrail_stop_event_data_store_ingestion

#' Stops a specified import
#'
#' @description
#' Stops a specified import.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_stop_import/](https://www.paws-r-sdk.com/docs/cloudtrail_stop_import/) for full documentation.
#'
#' @param ImportId &#91;required&#93; The ID of the import.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_stop_import
cloudtrail_stop_import <- function(ImportId) {
  op <- new_operation(
    name = "StopImport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$stop_import_input(ImportId = ImportId)
  output <- .cloudtrail$stop_import_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$stop_import <- cloudtrail_stop_import

#' Suspends the recording of Amazon Web Services API calls and log file
#' delivery for the specified trail
#'
#' @description
#' Suspends the recording of Amazon Web Services API calls and log file delivery for the specified trail. Under most circumstances, there is no need to use this action. You can update a trail without stopping it first. This action is the only way to stop recording. For a trail enabled in all Regions, this operation must be called from the Region in which the trail was created, or an `InvalidHomeRegionException` will occur. This operation cannot be called on the shadow trails (replicated trails in other Regions) of a trail enabled in all Regions.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_stop_logging/](https://www.paws-r-sdk.com/docs/cloudtrail_stop_logging/) for full documentation.
#'
#' @param Name &#91;required&#93; Specifies the name or the CloudTrail ARN of the trail for which
#' CloudTrail will stop logging Amazon Web Services API calls. The
#' following is the format of a trail ARN.
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#'
#' @keywords internal
#'
#' @rdname cloudtrail_stop_logging
cloudtrail_stop_logging <- function(Name) {
  op <- new_operation(
    name = "StopLogging",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$stop_logging_input(Name = Name)
  output <- .cloudtrail$stop_logging_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$stop_logging <- cloudtrail_stop_logging

#' Updates a channel specified by a required channel ARN or UUID
#'
#' @description
#' Updates a channel specified by a required channel ARN or UUID.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_update_channel/](https://www.paws-r-sdk.com/docs/cloudtrail_update_channel/) for full documentation.
#'
#' @param Channel &#91;required&#93; The ARN or ID (the ARN suffix) of the channel that you want to update.
#' @param Destinations The ARNs of event data stores that you want to log events arriving
#' through the channel.
#' @param Name Changes the name of the channel.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_update_channel
cloudtrail_update_channel <- function(Channel, Destinations = NULL, Name = NULL) {
  op <- new_operation(
    name = "UpdateChannel",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$update_channel_input(Channel = Channel, Destinations = Destinations, Name = Name)
  output <- .cloudtrail$update_channel_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$update_channel <- cloudtrail_update_channel

#' Updates the specified dashboard
#'
#' @description
#' Updates the specified dashboard.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_update_dashboard/](https://www.paws-r-sdk.com/docs/cloudtrail_update_dashboard/) for full documentation.
#'
#' @param DashboardId &#91;required&#93; The name or ARN of the dashboard.
#' @param Widgets An array of widgets for the dashboard. A custom dashboard can have a
#' maximum of 10 widgets.
#' 
#' To add new widgets, pass in an array that includes the existing widgets
#' along with any new widgets. Run the
#' [`get_dashboard`][cloudtrail_get_dashboard] operation to get the list of
#' widgets for the dashboard.
#' 
#' To remove widgets, pass in an array that includes the existing widgets
#' minus the widgets you want removed.
#' @param RefreshSchedule The refresh schedule configuration for the dashboard.
#' @param TerminationProtectionEnabled Specifies whether termination protection is enabled for the dashboard.
#' If termination protection is enabled, you cannot delete the dashboard
#' until termination protection is disabled.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_update_dashboard
cloudtrail_update_dashboard <- function(DashboardId, Widgets = NULL, RefreshSchedule = NULL, TerminationProtectionEnabled = NULL) {
  op <- new_operation(
    name = "UpdateDashboard",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$update_dashboard_input(DashboardId = DashboardId, Widgets = Widgets, RefreshSchedule = RefreshSchedule, TerminationProtectionEnabled = TerminationProtectionEnabled)
  output <- .cloudtrail$update_dashboard_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$update_dashboard <- cloudtrail_update_dashboard

#' Updates an event data store
#'
#' @description
#' Updates an event data store. The required `EventDataStore` value is an ARN or the ID portion of the ARN. Other parameters are optional, but at least one optional parameter must be specified, or CloudTrail throws an error. `RetentionPeriod` is in days, and valid values are integers between 7 and 3653 if the `BillingMode` is set to `EXTENDABLE_RETENTION_PRICING`, or between 7 and 2557 if `BillingMode` is set to `FIXED_RETENTION_PRICING`. By default, `TerminationProtection` is enabled.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_update_event_data_store/](https://www.paws-r-sdk.com/docs/cloudtrail_update_event_data_store/) for full documentation.
#'
#' @param EventDataStore &#91;required&#93; The ARN (or the ID suffix of the ARN) of the event data store that you
#' want to update.
#' @param Name The event data store name.
#' @param AdvancedEventSelectors The advanced event selectors used to select events for the event data
#' store. You can configure up to five advanced event selectors for each
#' event data store.
#' @param MultiRegionEnabled Specifies whether an event data store collects events from all Regions,
#' or only from the Region in which it was created.
#' @param OrganizationEnabled Specifies whether an event data store collects events logged for an
#' organization in Organizations.
#' 
#' Only the management account for the organization can convert an
#' organization event data store to a non-organization event data store, or
#' convert a non-organization event data store to an organization event
#' data store.
#' @param RetentionPeriod The retention period of the event data store, in days. If `BillingMode`
#' is set to `EXTENDABLE_RETENTION_PRICING`, you can set a retention period
#' of up to 3653 days, the equivalent of 10 years. If `BillingMode` is set
#' to `FIXED_RETENTION_PRICING`, you can set a retention period of up to
#' 2557 days, the equivalent of seven years.
#' 
#' CloudTrail Lake determines whether to retain an event by checking if the
#' `eventTime` of the event is within the specified retention period. For
#' example, if you set a retention period of 90 days, CloudTrail will
#' remove events when the `eventTime` is older than 90 days.
#' 
#' If you decrease the retention period of an event data store, CloudTrail
#' will remove any events with an `eventTime` older than the new retention
#' period. For example, if the previous retention period was 365 days and
#' you decrease it to 100 days, CloudTrail will remove events with an
#' `eventTime` older than 100 days.
#' @param TerminationProtectionEnabled Indicates that termination protection is enabled and the event data
#' store cannot be automatically deleted.
#' @param KmsKeyId Specifies the KMS key ID to use to encrypt the events delivered by
#' CloudTrail. The value can be an alias name prefixed by `alias/`, a fully
#' specified ARN to an alias, a fully specified ARN to a key, or a globally
#' unique identifier.
#' 
#' Disabling or deleting the KMS key, or removing CloudTrail permissions on
#' the key, prevents CloudTrail from logging events to the event data
#' store, and prevents users from querying the data in the event data store
#' that was encrypted with the key. After you associate an event data store
#' with a KMS key, the KMS key cannot be removed or changed. Before you
#' disable or delete a KMS key that you are using with an event data store,
#' delete or back up your event data store.
#' 
#' CloudTrail also supports KMS multi-Region keys. For more information
#' about multi-Region keys, see [Using multi-Region
#' keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
#' in the *Key Management Service Developer Guide*.
#' 
#' Examples:
#' 
#' -   `alias/MyAliasName`
#' 
#' -   `arn:aws:kms:us-east-2:123456789012:alias/MyAliasName`
#' 
#' -   `arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012`
#' 
#' -   `12345678-1234-1234-1234-123456789012`
#' @param BillingMode You can't change the billing mode from `EXTENDABLE_RETENTION_PRICING` to
#' `FIXED_RETENTION_PRICING`. If `BillingMode` is set to
#' `EXTENDABLE_RETENTION_PRICING` and you want to use
#' `FIXED_RETENTION_PRICING` instead, you'll need to stop ingestion on the
#' event data store and create a new event data store that uses
#' `FIXED_RETENTION_PRICING`.
#' 
#' The billing mode for the event data store determines the cost for
#' ingesting events and the default and maximum retention period for the
#' event data store.
#' 
#' The following are the possible values:
#' 
#' -   `EXTENDABLE_RETENTION_PRICING` - This billing mode is generally
#'     recommended if you want a flexible retention period of up to 3653
#'     days (about 10 years). The default retention period for this billing
#'     mode is 366 days.
#' 
#' -   `FIXED_RETENTION_PRICING` - This billing mode is recommended if you
#'     expect to ingest more than 25 TB of event data per month and need a
#'     retention period of up to 2557 days (about 7 years). The default
#'     retention period for this billing mode is 2557 days.
#' 
#' For more information about CloudTrail pricing, see [CloudTrail
#' Pricing](https://aws.amazon.com/cloudtrail/pricing/) and [Managing
#' CloudTrail Lake
#' costs](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-manage-costs.html).
#'
#' @keywords internal
#'
#' @rdname cloudtrail_update_event_data_store
cloudtrail_update_event_data_store <- function(EventDataStore, Name = NULL, AdvancedEventSelectors = NULL, MultiRegionEnabled = NULL, OrganizationEnabled = NULL, RetentionPeriod = NULL, TerminationProtectionEnabled = NULL, KmsKeyId = NULL, BillingMode = NULL) {
  op <- new_operation(
    name = "UpdateEventDataStore",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$update_event_data_store_input(EventDataStore = EventDataStore, Name = Name, AdvancedEventSelectors = AdvancedEventSelectors, MultiRegionEnabled = MultiRegionEnabled, OrganizationEnabled = OrganizationEnabled, RetentionPeriod = RetentionPeriod, TerminationProtectionEnabled = TerminationProtectionEnabled, KmsKeyId = KmsKeyId, BillingMode = BillingMode)
  output <- .cloudtrail$update_event_data_store_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$update_event_data_store <- cloudtrail_update_event_data_store

#' Updates trail settings that control what events you are logging, and how
#' to handle log files
#'
#' @description
#' Updates trail settings that control what events you are logging, and how to handle log files. Changes to a trail do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery. If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the bucket. [`update_trail`][cloudtrail_update_trail] must be called from the Region in which the trail was created; otherwise, an `InvalidHomeRegionException` is thrown.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudtrail_update_trail/](https://www.paws-r-sdk.com/docs/cloudtrail_update_trail/) for full documentation.
#'
#' @param Name &#91;required&#93; Specifies the name of the trail or trail ARN. If `Name` is a trail name,
#' the string must meet the following requirements:
#' 
#' -   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
#'     underscores (_), or dashes (-)
#' 
#' -   Start with a letter or number, and end with a letter or number
#' 
#' -   Be between 3 and 128 characters
#' 
#' -   Have no adjacent periods, underscores or dashes. Names like
#'     `my-_namespace` and `my--namespace` are not valid.
#' 
#' -   Not be in IP address format (for example, 192.168.5.4)
#' 
#' If `Name` is a trail ARN, it must be in the following format.
#' 
#' `arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail`
#' @param S3BucketName Specifies the name of the Amazon S3 bucket designated for publishing log
#' files. See [Amazon S3 Bucket naming
#' rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
#' @param S3KeyPrefix Specifies the Amazon S3 key prefix that comes after the name of the
#' bucket you have designated for log file delivery. For more information,
#' see [Finding Your CloudTrail Log
#' Files](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/get-and-view-cloudtrail-log-files.html#cloudtrail-find-log-files).
#' The maximum length is 200 characters.
#' @param SnsTopicName Specifies the name of the Amazon SNS topic defined for notification of
#' log file delivery. The maximum length is 256 characters.
#' @param IncludeGlobalServiceEvents Specifies whether the trail is publishing events from global services
#' such as IAM to the log files.
#' @param IsMultiRegionTrail Specifies whether the trail applies only to the current Region or to all
#' Regions. The default is false. If the trail exists only in the current
#' Region and this value is set to true, shadow trails (replications of the
#' trail) will be created in the other Regions. If the trail exists in all
#' Regions and this value is set to false, the trail will remain in the
#' Region where it was created, and its shadow trails in other Regions will
#' be deleted. As a best practice, consider using trails that log events in
#' all Regions.
#' @param EnableLogFileValidation Specifies whether log file validation is enabled. The default is false.
#' 
#' When you disable log file integrity validation, the chain of digest
#' files is broken after one hour. CloudTrail does not create digest files
#' for log files that were delivered during a period in which log file
#' integrity validation was disabled. For example, if you enable log file
#' integrity validation at noon on January 1, disable it at noon on January
#' 2, and re-enable it at noon on January 10, digest files will not be
#' created for the log files delivered from noon on January 2 to noon on
#' January 10. The same applies whenever you stop CloudTrail logging or
#' delete a trail.
#' @param CloudWatchLogsLogGroupArn Specifies a log group name using an Amazon Resource Name (ARN), a unique
#' identifier that represents the log group to which CloudTrail logs are
#' delivered. You must use a log group that exists in your account.
#' 
#' Not required unless you specify `CloudWatchLogsRoleArn`.
#' @param CloudWatchLogsRoleArn Specifies the role for the CloudWatch Logs endpoint to assume to write
#' to a user's log group. You must use a role that exists in your account.
#' @param KmsKeyId Specifies the KMS key ID to use to encrypt the logs delivered by
#' CloudTrail. The value can be an alias name prefixed by "alias/", a fully
#' specified ARN to an alias, a fully specified ARN to a key, or a globally
#' unique identifier.
#' 
#' CloudTrail also supports KMS multi-Region keys. For more information
#' about multi-Region keys, see [Using multi-Region
#' keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
#' in the *Key Management Service Developer Guide*.
#' 
#' Examples:
#' 
#' -   alias/MyAliasName
#' 
#' -   arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
#' 
#' -   arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
#' 
#' -   12345678-1234-1234-1234-123456789012
#' @param IsOrganizationTrail Specifies whether the trail is applied to all accounts in an
#' organization in Organizations, or only for the current Amazon Web
#' Services account. The default is false, and cannot be true unless the
#' call is made on behalf of an Amazon Web Services account that is the
#' management account for an organization in Organizations. If the trail is
#' not an organization trail and this is set to `true`, the trail will be
#' created in all Amazon Web Services accounts that belong to the
#' organization. If the trail is an organization trail and this is set to
#' `false`, the trail will remain in the current Amazon Web Services
#' account but be deleted from all member accounts in the organization.
#' 
#' Only the management account for the organization can convert an
#' organization trail to a non-organization trail, or convert a
#' non-organization trail to an organization trail.
#'
#' @keywords internal
#'
#' @rdname cloudtrail_update_trail
cloudtrail_update_trail <- function(Name, S3BucketName = NULL, S3KeyPrefix = NULL, SnsTopicName = NULL, IncludeGlobalServiceEvents = NULL, IsMultiRegionTrail = NULL, EnableLogFileValidation = NULL, CloudWatchLogsLogGroupArn = NULL, CloudWatchLogsRoleArn = NULL, KmsKeyId = NULL, IsOrganizationTrail = NULL) {
  op <- new_operation(
    name = "UpdateTrail",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudtrail$update_trail_input(Name = Name, S3BucketName = S3BucketName, S3KeyPrefix = S3KeyPrefix, SnsTopicName = SnsTopicName, IncludeGlobalServiceEvents = IncludeGlobalServiceEvents, IsMultiRegionTrail = IsMultiRegionTrail, EnableLogFileValidation = EnableLogFileValidation, CloudWatchLogsLogGroupArn = CloudWatchLogsLogGroupArn, CloudWatchLogsRoleArn = CloudWatchLogsRoleArn, KmsKeyId = KmsKeyId, IsOrganizationTrail = IsOrganizationTrail)
  output <- .cloudtrail$update_trail_output()
  config <- get_config()
  svc <- .cloudtrail$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudtrail$operations$update_trail <- cloudtrail_update_trail
