% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastservice_operations.R
\name{forecastservice_list_what_if_forecast_exports}
\alias{forecastservice_list_what_if_forecast_exports}
\title{Returns a list of what-if forecast exports created using the
CreateWhatIfForecastExport operation}
\usage{
forecastservice_list_what_if_forecast_exports(
  NextToken = NULL,
  MaxResults = NULL,
  Filters = NULL
)
}
\arguments{
\item{NextToken}{If the result of the previous request was truncated, the response
includes a \code{NextToken}. To retrieve the next set of results, use the
token in the next request. Tokens expire after 24 hours.}

\item{MaxResults}{The number of items to return in the response.}

\item{Filters}{An array of filters. For each filter, you provide a condition and a
match statement. The condition is either \code{IS} or \code{IS_NOT}, which
specifies whether to include or exclude the what-if forecast export jobs
that match the statement from the list, respectively. The match
statement consists of a key and a value.

\strong{Filter properties}
\itemize{
\item \code{Condition} - The condition to apply. Valid values are \code{IS} and
\code{IS_NOT}. To include the forecast export jobs that match the
statement, specify \code{IS}. To exclude matching forecast export jobs,
specify \code{IS_NOT}.
\item \code{Key} - The name of the parameter to filter on. Valid values are
\code{WhatIfForecastExportArn} and \code{Status}.
\item \code{Value} - The value to match.
}

For example, to list all jobs that export a forecast named
\emph{electricityWIFExport}, specify the following filter:

\verb{"Filters": [ \{ "Condition": "IS", "Key": "WhatIfForecastExportArn", "Value": "arn:aws:forecast:us-west-2:<acct-id>:forecast/electricityWIFExport" \} ]}}
}
\description{
Returns a list of what-if forecast exports created using the \code{\link[=forecastservice_create_what_if_forecast_export]{create_what_if_forecast_export}} operation. For each what-if forecast export, this operation returns a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve the complete set of properties by using the what-if forecast export ARN with the \code{\link[=forecastservice_describe_what_if_forecast_export]{describe_what_if_forecast_export}} operation.

See \url{https://www.paws-r-sdk.com/docs/forecastservice_list_what_if_forecast_exports/} for full documentation.
}
\keyword{internal}
