% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspacesweb_operations.R
\name{workspacesweb_create_user_settings}
\alias{workspacesweb_create_user_settings}
\title{Creates a user settings resource that can be associated with a web
portal}
\usage{
workspacesweb_create_user_settings(
  additionalEncryptionContext = NULL,
  clientToken = NULL,
  cookieSynchronizationConfiguration = NULL,
  copyAllowed,
  customerManagedKey = NULL,
  deepLinkAllowed = NULL,
  disconnectTimeoutInMinutes = NULL,
  downloadAllowed,
  idleDisconnectTimeoutInMinutes = NULL,
  pasteAllowed,
  printAllowed,
  tags = NULL,
  toolbarConfiguration = NULL,
  uploadAllowed
)
}
\arguments{
\item{additionalEncryptionContext}{The additional encryption context of the user settings.}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Idempotency ensures that an API request
completes only once. With an idempotent request, if the original request
completes successfully, subsequent retries with the same client token
returns the result from the original successful request.

If you do not specify a client token, one is automatically generated by
the Amazon Web Services SDK.}

\item{cookieSynchronizationConfiguration}{The configuration that specifies which cookies should be synchronized
from the end user's local browser to the remote browser.}

\item{copyAllowed}{[required] Specifies whether the user can copy text from the streaming session to
the local device.}

\item{customerManagedKey}{The customer managed key used to encrypt sensitive information in the
user settings.}

\item{deepLinkAllowed}{Specifies whether the user can use deep links that open automatically
when connecting to a session.}

\item{disconnectTimeoutInMinutes}{The amount of time that a streaming session remains active after users
disconnect.}

\item{downloadAllowed}{[required] Specifies whether the user can download files from the streaming session
to the local device.}

\item{idleDisconnectTimeoutInMinutes}{The amount of time that users can be idle (inactive) before they are
disconnected from their streaming session and the disconnect timeout
interval begins.}

\item{pasteAllowed}{[required] Specifies whether the user can paste text from the local device to the
streaming session.}

\item{printAllowed}{[required] Specifies whether the user can print to the local device.}

\item{tags}{The tags to add to the user settings resource. A tag is a key-value
pair.}

\item{toolbarConfiguration}{The configuration of the toolbar. This allows administrators to select
the toolbar type and visual mode, set maximum display resolution for
sessions, and choose which items are visible to end users during their
sessions. If administrators do not modify these settings, end users
retain control over their toolbar preferences.}

\item{uploadAllowed}{[required] Specifies whether the user can upload files from the local device to the
streaming session.}
}
\description{
Creates a user settings resource that can be associated with a web portal. Once associated with a web portal, user settings control how users can transfer data between a streaming session and the their local devices.

See \url{https://www.paws-r-sdk.com/docs/workspacesweb_create_user_settings/} for full documentation.
}
\keyword{internal}
