% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paymentcryptographydataplane_operations.R
\name{paymentcryptographydataplane_generate_mac_emv_pin_change}
\alias{paymentcryptographydataplane_generate_mac_emv_pin_change}
\title{Generates an issuer script mac for EMV payment cards that use offline
PINs as the cardholder verification method (CVM)}
\usage{
paymentcryptographydataplane_generate_mac_emv_pin_change(
  NewPinPekIdentifier,
  NewEncryptedPinBlock,
  PinBlockFormat,
  SecureMessagingIntegrityKeyIdentifier,
  SecureMessagingConfidentialityKeyIdentifier,
  MessageData,
  DerivationMethodAttributes
)
}
\arguments{
\item{NewPinPekIdentifier}{[required] The \code{keyARN} of the PEK protecting the incoming new encrypted PIN block.}

\item{NewEncryptedPinBlock}{[required] The incoming new encrypted PIN block data for offline pin change on an
EMV card.}

\item{PinBlockFormat}{[required] The PIN encoding format of the incoming new encrypted PIN block as
specified in ISO 9564.}

\item{SecureMessagingIntegrityKeyIdentifier}{[required] The \code{keyARN} of the issuer master key (IMK-SMI) used to authenticate the
issuer script response.}

\item{SecureMessagingConfidentialityKeyIdentifier}{[required] The \code{keyARN} of the issuer master key (IMK-SMC) used to protect the PIN
block data in the issuer script response.}

\item{MessageData}{[required] The message data is the APDU command from the card reader or terminal.
The target encrypted PIN block, after translation to ISO2 format, is
appended to this message data to generate an issuer script response.}

\item{DerivationMethodAttributes}{[required] The attributes and data values to derive payment card specific
confidentiality and integrity keys.}
}
\description{
Generates an issuer script mac for EMV payment cards that use offline PINs as the cardholder verification method (CVM).

See \url{https://www.paws-r-sdk.com/docs/paymentcryptographydataplane_generate_mac_emv_pin_change/} for full documentation.
}
\keyword{internal}
