# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include savingsplans_service.R
NULL

#' Creates a Savings Plan
#'
#' @description
#' Creates a Savings Plan.
#'
#' See [https://www.paws-r-sdk.com/docs/savingsplans_create_savings_plan/](https://www.paws-r-sdk.com/docs/savingsplans_create_savings_plan/) for full documentation.
#'
#' @param savingsPlanOfferingId &#91;required&#93; The ID of the offering.
#' @param commitment &#91;required&#93; The hourly commitment, in the same currency of the
#' `savingsPlanOfferingId`. This is a value between 0.001 and 1 million.
#' You cannot specify more than five digits after the decimal point.
#' @param upfrontPaymentAmount The up-front payment amount. This is a whole number between 50 and 99
#' percent of the total value of the Savings Plan. This parameter is only
#' supported if the payment option is `Partial Upfront`.
#' @param purchaseTime The purchase time of the Savings Plan in UTC format
#' (YYYY-MM-DDTHH:MM:SSZ).
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param tags One or more tags.
#'
#' @keywords internal
#'
#' @rdname savingsplans_create_savings_plan
savingsplans_create_savings_plan <- function(savingsPlanOfferingId, commitment, upfrontPaymentAmount = NULL, purchaseTime = NULL, clientToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateSavingsPlan",
    http_method = "POST",
    http_path = "/CreateSavingsPlan",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .savingsplans$create_savings_plan_input(savingsPlanOfferingId = savingsPlanOfferingId, commitment = commitment, upfrontPaymentAmount = upfrontPaymentAmount, purchaseTime = purchaseTime, clientToken = clientToken, tags = tags)
  output <- .savingsplans$create_savings_plan_output()
  config <- get_config()
  svc <- .savingsplans$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.savingsplans$operations$create_savings_plan <- savingsplans_create_savings_plan

#' Deletes the queued purchase for the specified Savings Plan
#'
#' @description
#' Deletes the queued purchase for the specified Savings Plan.
#'
#' See [https://www.paws-r-sdk.com/docs/savingsplans_delete_queued_savings_plan/](https://www.paws-r-sdk.com/docs/savingsplans_delete_queued_savings_plan/) for full documentation.
#'
#' @param savingsPlanId &#91;required&#93; The ID of the Savings Plan.
#'
#' @keywords internal
#'
#' @rdname savingsplans_delete_queued_savings_plan
savingsplans_delete_queued_savings_plan <- function(savingsPlanId) {
  op <- new_operation(
    name = "DeleteQueuedSavingsPlan",
    http_method = "POST",
    http_path = "/DeleteQueuedSavingsPlan",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .savingsplans$delete_queued_savings_plan_input(savingsPlanId = savingsPlanId)
  output <- .savingsplans$delete_queued_savings_plan_output()
  config <- get_config()
  svc <- .savingsplans$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.savingsplans$operations$delete_queued_savings_plan <- savingsplans_delete_queued_savings_plan

#' Describes the rates for the specified Savings Plan
#'
#' @description
#' Describes the rates for the specified Savings Plan.
#'
#' See [https://www.paws-r-sdk.com/docs/savingsplans_describe_savings_plan_rates/](https://www.paws-r-sdk.com/docs/savingsplans_describe_savings_plan_rates/) for full documentation.
#'
#' @param savingsPlanId &#91;required&#93; The ID of the Savings Plan.
#' @param filters The filters.
#' @param nextToken The token for the next page of results.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' additional results, make another call with the returned token value.
#'
#' @keywords internal
#'
#' @rdname savingsplans_describe_savings_plan_rates
savingsplans_describe_savings_plan_rates <- function(savingsPlanId, filters = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeSavingsPlanRates",
    http_method = "POST",
    http_path = "/DescribeSavingsPlanRates",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .savingsplans$describe_savings_plan_rates_input(savingsPlanId = savingsPlanId, filters = filters, nextToken = nextToken, maxResults = maxResults)
  output <- .savingsplans$describe_savings_plan_rates_output()
  config <- get_config()
  svc <- .savingsplans$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.savingsplans$operations$describe_savings_plan_rates <- savingsplans_describe_savings_plan_rates

#' Describes the specified Savings Plans
#'
#' @description
#' Describes the specified Savings Plans.
#'
#' See [https://www.paws-r-sdk.com/docs/savingsplans_describe_savings_plans/](https://www.paws-r-sdk.com/docs/savingsplans_describe_savings_plans/) for full documentation.
#'
#' @param savingsPlanArns The Amazon Resource Names (ARN) of the Savings Plans.
#' @param savingsPlanIds The IDs of the Savings Plans.
#' @param nextToken The token for the next page of results.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' additional results, make another call with the returned token value.
#' @param states The current states of the Savings Plans.
#' @param filters The filters.
#'
#' @keywords internal
#'
#' @rdname savingsplans_describe_savings_plans
savingsplans_describe_savings_plans <- function(savingsPlanArns = NULL, savingsPlanIds = NULL, nextToken = NULL, maxResults = NULL, states = NULL, filters = NULL) {
  op <- new_operation(
    name = "DescribeSavingsPlans",
    http_method = "POST",
    http_path = "/DescribeSavingsPlans",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .savingsplans$describe_savings_plans_input(savingsPlanArns = savingsPlanArns, savingsPlanIds = savingsPlanIds, nextToken = nextToken, maxResults = maxResults, states = states, filters = filters)
  output <- .savingsplans$describe_savings_plans_output()
  config <- get_config()
  svc <- .savingsplans$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.savingsplans$operations$describe_savings_plans <- savingsplans_describe_savings_plans

#' Describes the offering rates for the specified Savings Plans
#'
#' @description
#' Describes the offering rates for the specified Savings Plans.
#'
#' See [https://www.paws-r-sdk.com/docs/savingsplans_describe_savings_plans_offering_rates/](https://www.paws-r-sdk.com/docs/savingsplans_describe_savings_plans_offering_rates/) for full documentation.
#'
#' @param savingsPlanOfferingIds The IDs of the offerings.
#' @param savingsPlanPaymentOptions The payment options.
#' @param savingsPlanTypes The plan types.
#' @param products The Amazon Web Services products.
#' @param serviceCodes The services.
#' @param usageTypes The usage details of the line item in the billing report.
#' @param operations The specific Amazon Web Services operation for the line item in the
#' billing report.
#' @param filters The filters.
#' @param nextToken The token for the next page of results.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' additional results, make another call with the returned token value.
#'
#' @keywords internal
#'
#' @rdname savingsplans_describe_savings_plans_offering_rates
savingsplans_describe_savings_plans_offering_rates <- function(savingsPlanOfferingIds = NULL, savingsPlanPaymentOptions = NULL, savingsPlanTypes = NULL, products = NULL, serviceCodes = NULL, usageTypes = NULL, operations = NULL, filters = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeSavingsPlansOfferingRates",
    http_method = "POST",
    http_path = "/DescribeSavingsPlansOfferingRates",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .savingsplans$describe_savings_plans_offering_rates_input(savingsPlanOfferingIds = savingsPlanOfferingIds, savingsPlanPaymentOptions = savingsPlanPaymentOptions, savingsPlanTypes = savingsPlanTypes, products = products, serviceCodes = serviceCodes, usageTypes = usageTypes, operations = operations, filters = filters, nextToken = nextToken, maxResults = maxResults)
  output <- .savingsplans$describe_savings_plans_offering_rates_output()
  config <- get_config()
  svc <- .savingsplans$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.savingsplans$operations$describe_savings_plans_offering_rates <- savingsplans_describe_savings_plans_offering_rates

#' Describes the offerings for the specified Savings Plans
#'
#' @description
#' Describes the offerings for the specified Savings Plans.
#'
#' See [https://www.paws-r-sdk.com/docs/savingsplans_describe_savings_plans_offerings/](https://www.paws-r-sdk.com/docs/savingsplans_describe_savings_plans_offerings/) for full documentation.
#'
#' @param offeringIds The IDs of the offerings.
#' @param paymentOptions The payment options.
#' @param productType The product type.
#' @param planTypes The plan types.
#' @param durations The duration, in seconds.
#' @param currencies The currencies.
#' @param descriptions The descriptions.
#' @param serviceCodes The services.
#' @param usageTypes The usage details of the line item in the billing report.
#' @param operations The specific Amazon Web Services operation for the line item in the
#' billing report.
#' @param filters The filters.
#' @param nextToken The token for the next page of results.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' additional results, make another call with the returned token value.
#'
#' @keywords internal
#'
#' @rdname savingsplans_describe_savings_plans_offerings
savingsplans_describe_savings_plans_offerings <- function(offeringIds = NULL, paymentOptions = NULL, productType = NULL, planTypes = NULL, durations = NULL, currencies = NULL, descriptions = NULL, serviceCodes = NULL, usageTypes = NULL, operations = NULL, filters = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeSavingsPlansOfferings",
    http_method = "POST",
    http_path = "/DescribeSavingsPlansOfferings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .savingsplans$describe_savings_plans_offerings_input(offeringIds = offeringIds, paymentOptions = paymentOptions, productType = productType, planTypes = planTypes, durations = durations, currencies = currencies, descriptions = descriptions, serviceCodes = serviceCodes, usageTypes = usageTypes, operations = operations, filters = filters, nextToken = nextToken, maxResults = maxResults)
  output <- .savingsplans$describe_savings_plans_offerings_output()
  config <- get_config()
  svc <- .savingsplans$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.savingsplans$operations$describe_savings_plans_offerings <- savingsplans_describe_savings_plans_offerings

#' Lists the tags for the specified resource
#'
#' @description
#' Lists the tags for the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/savingsplans_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/savingsplans_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname savingsplans_list_tags_for_resource
savingsplans_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/ListTagsForResource",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .savingsplans$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .savingsplans$list_tags_for_resource_output()
  config <- get_config()
  svc <- .savingsplans$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.savingsplans$operations$list_tags_for_resource <- savingsplans_list_tags_for_resource

#' Returns the specified Savings Plan
#'
#' @description
#' Returns the specified Savings Plan.
#'
#' See [https://www.paws-r-sdk.com/docs/savingsplans_return_savings_plan/](https://www.paws-r-sdk.com/docs/savingsplans_return_savings_plan/) for full documentation.
#'
#' @param savingsPlanId &#91;required&#93; The ID of the Savings Plan.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname savingsplans_return_savings_plan
savingsplans_return_savings_plan <- function(savingsPlanId, clientToken = NULL) {
  op <- new_operation(
    name = "ReturnSavingsPlan",
    http_method = "POST",
    http_path = "/ReturnSavingsPlan",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .savingsplans$return_savings_plan_input(savingsPlanId = savingsPlanId, clientToken = clientToken)
  output <- .savingsplans$return_savings_plan_output()
  config <- get_config()
  svc <- .savingsplans$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.savingsplans$operations$return_savings_plan <- savingsplans_return_savings_plan

#' Adds the specified tags to the specified resource
#'
#' @description
#' Adds the specified tags to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/savingsplans_tag_resource/](https://www.paws-r-sdk.com/docs/savingsplans_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tags &#91;required&#93; One or more tags. For example, \{ "tags": \{"key1":"value1",
#' "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname savingsplans_tag_resource
savingsplans_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/TagResource",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .savingsplans$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .savingsplans$tag_resource_output()
  config <- get_config()
  svc <- .savingsplans$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.savingsplans$operations$tag_resource <- savingsplans_tag_resource

#' Removes the specified tags from the specified resource
#'
#' @description
#' Removes the specified tags from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/savingsplans_untag_resource/](https://www.paws-r-sdk.com/docs/savingsplans_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tagKeys &#91;required&#93; The tag keys.
#'
#' @keywords internal
#'
#' @rdname savingsplans_untag_resource
savingsplans_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/UntagResource",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .savingsplans$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .savingsplans$untag_resource_output()
  config <- get_config()
  svc <- .savingsplans$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.savingsplans$operations$untag_resource <- savingsplans_untag_resource
