# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include marketplacemetering_service.R
NULL

#' BatchMeterUsage is called from a SaaS application listed on AWS
#' Marketplace to post metering records for a set of customers
#'
#' @description
#' [`batch_meter_usage`][marketplacemetering_batch_meter_usage] is called from a SaaS application listed on AWS Marketplace to post metering records for a set of customers.
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacemetering_batch_meter_usage/](https://www.paws-r-sdk.com/docs/marketplacemetering_batch_meter_usage/) for full documentation.
#'
#' @param UsageRecords &#91;required&#93; The set of `UsageRecords` to submit.
#' [`batch_meter_usage`][marketplacemetering_batch_meter_usage] accepts up
#' to 25 `UsageRecords` at a time.
#' @param ProductCode &#91;required&#93; Product code is used to uniquely identify a product in AWS Marketplace.
#' The product code should be the same as the one used during the
#' publishing of a new product.
#'
#' @keywords internal
#'
#' @rdname marketplacemetering_batch_meter_usage
marketplacemetering_batch_meter_usage <- function(UsageRecords, ProductCode) {
  op <- new_operation(
    name = "BatchMeterUsage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .marketplacemetering$batch_meter_usage_input(UsageRecords = UsageRecords, ProductCode = ProductCode)
  output <- .marketplacemetering$batch_meter_usage_output()
  config <- get_config()
  svc <- .marketplacemetering$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacemetering$operations$batch_meter_usage <- marketplacemetering_batch_meter_usage

#' API to emit metering records
#'
#' @description
#' API to emit metering records. For identical requests, the API is idempotent. It simply returns the metering record ID.
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacemetering_meter_usage/](https://www.paws-r-sdk.com/docs/marketplacemetering_meter_usage/) for full documentation.
#'
#' @param ProductCode &#91;required&#93; Product code is used to uniquely identify a product in AWS Marketplace.
#' The product code should be the same as the one used during the
#' publishing of a new product.
#' @param Timestamp &#91;required&#93; Timestamp, in UTC, for which the usage is being reported. Your
#' application can meter usage for up to one hour in the past. Make sure
#' the `timestamp` value is not before the start of the software usage.
#' @param UsageDimension &#91;required&#93; It will be one of the fcp dimension name provided during the publishing
#' of the product.
#' @param UsageQuantity Consumption value for the hour. Defaults to `0` if not specified.
#' @param DryRun Checks whether you have the permissions required for the action, but
#' does not make the request. If you have the permissions, the request
#' returns `DryRunOperation`; otherwise, it returns
#' `UnauthorizedException`. Defaults to `false` if not specified.
#' @param UsageAllocations The set of `UsageAllocations` to submit.
#' 
#' The sum of all `UsageAllocation` quantities must equal the
#' `UsageQuantity` of the [`meter_usage`][marketplacemetering_meter_usage]
#' request, and each `UsageAllocation` must have a unique set of tags
#' (include no tags).
#'
#' @keywords internal
#'
#' @rdname marketplacemetering_meter_usage
marketplacemetering_meter_usage <- function(ProductCode, Timestamp, UsageDimension, UsageQuantity = NULL, DryRun = NULL, UsageAllocations = NULL) {
  op <- new_operation(
    name = "MeterUsage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .marketplacemetering$meter_usage_input(ProductCode = ProductCode, Timestamp = Timestamp, UsageDimension = UsageDimension, UsageQuantity = UsageQuantity, DryRun = DryRun, UsageAllocations = UsageAllocations)
  output <- .marketplacemetering$meter_usage_output()
  config <- get_config()
  svc <- .marketplacemetering$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacemetering$operations$meter_usage <- marketplacemetering_meter_usage

#' Paid container software products sold through AWS Marketplace must
#' integrate with the AWS Marketplace Metering Service and call the
#' RegisterUsage operation for software entitlement and metering
#'
#' @description
#' Paid container software products sold through AWS Marketplace must integrate with the AWS Marketplace Metering Service and call the [`register_usage`][marketplacemetering_register_usage] operation for software entitlement and metering. Free and BYOL products for Amazon ECS or Amazon EKS aren't required to call [`register_usage`][marketplacemetering_register_usage], but you may choose to do so if you would like to receive usage data in your seller reports. The sections below explain the behavior of [`register_usage`][marketplacemetering_register_usage]. [`register_usage`][marketplacemetering_register_usage] performs two primary functions: metering and entitlement.
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacemetering_register_usage/](https://www.paws-r-sdk.com/docs/marketplacemetering_register_usage/) for full documentation.
#'
#' @param ProductCode &#91;required&#93; Product code is used to uniquely identify a product in AWS Marketplace.
#' The product code should be the same as the one used during the
#' publishing of a new product.
#' @param PublicKeyVersion &#91;required&#93; Public Key Version provided by AWS Marketplace
#' @param Nonce (Optional) To scope down the registration to a specific running software
#' instance and guard against replay attacks.
#'
#' @keywords internal
#'
#' @rdname marketplacemetering_register_usage
marketplacemetering_register_usage <- function(ProductCode, PublicKeyVersion, Nonce = NULL) {
  op <- new_operation(
    name = "RegisterUsage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .marketplacemetering$register_usage_input(ProductCode = ProductCode, PublicKeyVersion = PublicKeyVersion, Nonce = Nonce)
  output <- .marketplacemetering$register_usage_output()
  config <- get_config()
  svc <- .marketplacemetering$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacemetering$operations$register_usage <- marketplacemetering_register_usage

#' ResolveCustomer is called by a SaaS application during the registration
#' process
#'
#' @description
#' [`resolve_customer`][marketplacemetering_resolve_customer] is called by a SaaS application during the registration process. When a buyer visits your website during the registration process, the buyer submits a registration token through their browser. The registration token is resolved through this API to obtain a `CustomerIdentifier` along with the `CustomerAWSAccountId` and `ProductCode`.
#'
#' See [https://www.paws-r-sdk.com/docs/marketplacemetering_resolve_customer/](https://www.paws-r-sdk.com/docs/marketplacemetering_resolve_customer/) for full documentation.
#'
#' @param RegistrationToken &#91;required&#93; When a buyer visits your website during the registration process, the
#' buyer submits a registration token through the browser. The registration
#' token is resolved to obtain a `CustomerIdentifier` along with the
#' `CustomerAWSAccountId` and `ProductCode`.
#'
#' @keywords internal
#'
#' @rdname marketplacemetering_resolve_customer
marketplacemetering_resolve_customer <- function(RegistrationToken) {
  op <- new_operation(
    name = "ResolveCustomer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .marketplacemetering$resolve_customer_input(RegistrationToken = RegistrationToken)
  output <- .marketplacemetering$resolve_customer_output()
  config <- get_config()
  svc <- .marketplacemetering$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacemetering$operations$resolve_customer <- marketplacemetering_resolve_customer
