% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_update_bucket}
\alias{lightsail_update_bucket}
\title{Updates an existing Amazon Lightsail bucket}
\usage{
lightsail_update_bucket(
  bucketName,
  accessRules = NULL,
  versioning = NULL,
  readonlyAccessAccounts = NULL,
  accessLogConfig = NULL
)
}
\arguments{
\item{bucketName}{[required] The name of the bucket to update.}

\item{accessRules}{An object that sets the public accessibility of objects in the specified
bucket.}

\item{versioning}{Specifies whether to enable or suspend versioning of objects in the
bucket.

The following options can be specified:
\itemize{
\item \code{Enabled} - Enables versioning of objects in the specified bucket.
\item \code{Suspended} - Suspends versioning of objects in the specified
bucket. Existing object versions are retained.
}}

\item{readonlyAccessAccounts}{An array of strings to specify the Amazon Web Services account IDs that
can access the bucket.

You can give a maximum of 10 Amazon Web Services accounts access to a
bucket.}

\item{accessLogConfig}{An object that describes the access log configuration for the bucket.}
}
\description{
Updates an existing Amazon Lightsail bucket.

See \url{https://www.paws-r-sdk.com/docs/lightsail_update_bucket/} for full documentation.
}
\keyword{internal}
