% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_bundles}
\alias{lightsail_get_bundles}
\title{Returns the bundles that you can apply to an Amazon Lightsail instance
when you create it}
\usage{
lightsail_get_bundles(
  includeInactive = NULL,
  pageToken = NULL,
  appCategory = NULL
)
}
\arguments{
\item{includeInactive}{A Boolean value that indicates whether to include inactive (unavailable)
bundles in the response of your request.}

\item{pageToken}{The token to advance to the next page of results from your request.

To get a page token, perform an initial
\code{\link[=lightsail_get_bundles]{get_bundles}} request. If your results are
paginated, the response will return a next page token that you can
specify as the page token in a subsequent request.}

\item{appCategory}{Returns a list of bundles that are specific to Lightsail for Research.

You must use this parameter to view Lightsail for Research bundles.}
}
\description{
Returns the bundles that you can apply to an Amazon Lightsail instance when you create it.

See \url{https://www.paws-r-sdk.com/docs/lightsail_get_bundles/} for full documentation.
}
\keyword{internal}
