% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_list_functions}
\alias{lambda_list_functions}
\title{Returns a list of Lambda functions, with the version-specific
configuration of each}
\usage{
lambda_list_functions(
  MasterRegion = NULL,
  FunctionVersion = NULL,
  Marker = NULL,
  MaxItems = NULL
)
}
\arguments{
\item{MasterRegion}{For Lambda@Edge functions, the Amazon Web Services Region of the master
function. For example, \code{us-east-1} filters the list of functions to
include only Lambda@Edge functions replicated from a master function in
US East (N. Virginia). If specified, you must set \code{FunctionVersion} to
\code{ALL}.}

\item{FunctionVersion}{Set to \code{ALL} to include entries for all published versions of each
function.}

\item{Marker}{Specify the pagination token that's returned by a previous request to
retrieve the next page of results.}

\item{MaxItems}{The maximum number of functions to return in the response. Note that
\code{\link[=lambda_list_functions]{list_functions}} returns a maximum of 50 items
in each response, even if you set the number higher.}
}
\description{
Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50 functions per call.

See \url{https://www.paws-r-sdk.com/docs/lambda_list_functions/} for full documentation.
}
\keyword{internal}
