% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_update_task_protection}
\alias{ecs_update_task_protection}
\title{Updates the protection status of a task}
\usage{
ecs_update_task_protection(
  cluster,
  tasks,
  protectionEnabled,
  expiresInMinutes = NULL
)
}
\arguments{
\item{cluster}{[required] The short name or full Amazon Resource Name (ARN) of the cluster that
hosts the service that the task sets exist in.}

\item{tasks}{[required] A list of up to 10 task IDs or full ARN entries.}

\item{protectionEnabled}{[required] Specify \code{true} to mark a task for protection and \code{false} to unset
protection, making it eligible for termination.}

\item{expiresInMinutes}{If you set \code{protectionEnabled} to \code{true}, you can specify the duration
for task protection in minutes. You can specify a value from 1 minute to
up to 2,880 minutes (48 hours). During this time, your task will not be
terminated by scale-in events from Service Auto Scaling or deployments.
After this time period lapses, \code{protectionEnabled} will be reset to
\code{false}.

If you don’t specify the time, then the task is automatically protected
for 120 minutes (2 hours).}
}
\description{
Updates the protection status of a task. You can set \code{protectionEnabled} to \code{true} to protect your task from termination during scale-in events from \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-auto-scaling.html}{Service Autoscaling} or \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/}{deployments}.

See \url{https://www.paws-r-sdk.com/docs/ecs_update_task_protection/} for full documentation.
}
\keyword{internal}
