% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_create_capacity_provider}
\alias{ecs_create_capacity_provider}
\title{Creates a new capacity provider}
\usage{
ecs_create_capacity_provider(name, autoScalingGroupProvider, tags = NULL)
}
\arguments{
\item{name}{[required] The name of the capacity provider. Up to 255 characters are allowed.
They include letters (both upper and lowercase letters), numbers,
underscores (_), and hyphens (-). The name can't be prefixed with
"\code{aws}", "\code{ecs}", or "\code{fargate}".}

\item{autoScalingGroupProvider}{[required] The details of the Auto Scaling group for the capacity provider.}

\item{tags}{The metadata that you apply to the capacity provider to categorize and
organize them more conveniently. Each tag consists of a key and an
optional value. You define both of them.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8
\item Maximum value length - 256 Unicode characters in UTF-8
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case-sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for either keys or values as it is reserved for
Amazon Web Services use. You cannot edit or delete tag keys or
values with this prefix. Tags with this prefix do not count against
your tags per resource limit.
}}
}
\description{
Creates a new capacity provider. Capacity providers are associated with an Amazon ECS cluster and are used in capacity provider strategies to facilitate cluster auto scaling.

See \url{https://www.paws-r-sdk.com/docs/ecs_create_capacity_provider/} for full documentation.
}
\keyword{internal}
