% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_vpn_connection_device_sample_configuration}
\alias{ec2_get_vpn_connection_device_sample_configuration}
\title{Download an Amazon Web Services-provided sample configuration file to be
used with the customer gateway device specified for your Site-to-Site
VPN connection}
\usage{
ec2_get_vpn_connection_device_sample_configuration(
  VpnConnectionId,
  VpnConnectionDeviceTypeId,
  InternetKeyExchangeVersion = NULL,
  DryRun = NULL
)
}
\arguments{
\item{VpnConnectionId}{[required] The \code{VpnConnectionId} specifies the Site-to-Site VPN connection used for
the sample configuration.}

\item{VpnConnectionDeviceTypeId}{[required] Device identifier provided by the
\code{\link[=ec2_get_vpn_connection_device_types]{get_vpn_connection_device_types}}
API.}

\item{InternetKeyExchangeVersion}{The IKE version to be used in the sample configuration file for your
customer gateway device. You can specify one of the following versions:
\code{ikev1} or \code{ikev2}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Download an Amazon Web Services-provided sample configuration file to be used with the customer gateway device specified for your Site-to-Site VPN connection.

See \url{https://www.paws-r-sdk.com/docs/ec2_get_vpn_connection_device_sample_configuration/} for full documentation.
}
\keyword{internal}
