% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_ipam_external_resource_verification_tokens}
\alias{ec2_describe_ipam_external_resource_verification_tokens}
\title{Describe verification tokens}
\usage{
ec2_describe_ipam_external_resource_verification_tokens(
  DryRun = NULL,
  Filters = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  IpamExternalResourceVerificationTokenIds = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{One or more filters for the request. For more information about
filtering, see \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html}{Filtering CLI output}.

Available filters:
\itemize{
\item \code{ipam-arn}
\item \code{ipam-external-resource-verification-token-arn}
\item \code{ipam-external-resource-verification-token-id}
\item \code{ipam-id}
\item \code{ipam-region}
\item \code{state}
\item \code{status}
\item \code{token-name}
\item \code{token-value}
}}

\item{NextToken}{The token for the next page of results.}

\item{MaxResults}{The maximum number of tokens to return in one page of results.}

\item{IpamExternalResourceVerificationTokenIds}{Verification token IDs.}
}
\description{
Describe verification tokens. A verification token is an Amazon Web Services-generated random value that you can use to prove ownership of an external resource. For example, you can use a verification token to validate that you control a public IP address range when you bring an IP address range to Amazon Web Services (BYOIP).

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_ipam_external_resource_verification_tokens/} for full documentation.
}
\keyword{internal}
