% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_route}
\alias{ec2_delete_route}
\title{Deletes the specified route from the specified route table}
\usage{
ec2_delete_route(
  DestinationPrefixListId = NULL,
  DryRun = NULL,
  RouteTableId,
  DestinationCidrBlock = NULL,
  DestinationIpv6CidrBlock = NULL
)
}
\arguments{
\item{DestinationPrefixListId}{The ID of the prefix list for the route.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{RouteTableId}{[required] The ID of the route table.}

\item{DestinationCidrBlock}{The IPv4 CIDR range for the route. The value you specify must match the
CIDR for the route exactly.}

\item{DestinationIpv6CidrBlock}{The IPv6 CIDR range for the route. The value you specify must match the
CIDR for the route exactly.}
}
\description{
Deletes the specified route from the specified route table.

See \url{https://www.paws-r-sdk.com/docs/ec2_delete_route/} for full documentation.
}
\keyword{internal}
