% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_cancel_conversion_task}
\alias{ec2_cancel_conversion_task}
\title{Cancels an active conversion task}
\usage{
ec2_cancel_conversion_task(
  DryRun = NULL,
  ConversionTaskId,
  ReasonMessage = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ConversionTaskId}{[required] The ID of the conversion task.}

\item{ReasonMessage}{The reason for canceling the conversion task.}
}
\description{
Cancels an active conversion task. The task can be the import of an instance or volume. The action removes all artifacts of the conversion, including a partially uploaded volume or instance. If the conversion is complete or is in the process of transferring the final disk image, the command fails and returns an exception.

See \url{https://www.paws-r-sdk.com/docs/ec2_cancel_conversion_task/} for full documentation.
}
\keyword{internal}
