% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeoptimizer_operations.R
\name{computeoptimizer_get_rds_database_recommendations}
\alias{computeoptimizer_get_rds_database_recommendations}
\title{Returns Amazon RDS recommendations}
\usage{
computeoptimizer_get_rds_database_recommendations(
  resourceArns = NULL,
  nextToken = NULL,
  maxResults = NULL,
  filters = NULL,
  accountIds = NULL,
  recommendationPreferences = NULL
)
}
\arguments{
\item{resourceArns}{The ARN that identifies the Amazon RDS.

The following is the format of the ARN:

\code{arn:aws:rds:{region}:{accountId}:db:{resourceName}}

The following is the format of a DB Cluster ARN:

\code{arn:aws:rds:{region}:{accountId}:cluster:{resourceName}}}

\item{nextToken}{The token to advance to the next page of Amazon RDS recommendations.}

\item{maxResults}{The maximum number of Amazon RDS recommendations to return with a single
request.

To retrieve the remaining results, make another request with the
returned \code{nextToken} value.}

\item{filters}{An array of objects to specify a filter that returns a more specific
list of Amazon RDS recommendations.}

\item{accountIds}{Return the Amazon RDS recommendations to the specified Amazon Web
Services account IDs.

If your account is the management account or the delegated administrator
of an organization, use this parameter to return the Amazon RDS
recommendations to specific member accounts.

You can only specify one account ID per request.}

\item{recommendationPreferences}{}
}
\description{
Returns Amazon RDS recommendations.

See \url{https://www.paws-r-sdk.com/docs/computeoptimizer_get_rds_database_recommendations/} for full documentation.
}
\keyword{internal}
