% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schemas_service.R
\name{schemas}
\alias{schemas}
\title{Schemas}
\usage{
schemas(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon EventBridge Schema Registry
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- schemas(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=schemas_create_discoverer]{create_discoverer} \tab Creates a discoverer\cr
\link[=schemas_create_registry]{create_registry} \tab Creates a registry\cr
\link[=schemas_create_schema]{create_schema} \tab Creates a schema definition\cr
\link[=schemas_delete_discoverer]{delete_discoverer} \tab Deletes a discoverer\cr
\link[=schemas_delete_registry]{delete_registry} \tab Deletes a Registry\cr
\link[=schemas_delete_resource_policy]{delete_resource_policy} \tab Delete the resource-based policy attached to the specified registry\cr
\link[=schemas_delete_schema]{delete_schema} \tab Delete a schema definition\cr
\link[=schemas_delete_schema_version]{delete_schema_version} \tab Delete the schema version definition\cr
\link[=schemas_describe_code_binding]{describe_code_binding} \tab Describe the code binding URI\cr
\link[=schemas_describe_discoverer]{describe_discoverer} \tab Describes the discoverer\cr
\link[=schemas_describe_registry]{describe_registry} \tab Describes the registry\cr
\link[=schemas_describe_schema]{describe_schema} \tab Retrieve the schema definition\cr
\link[=schemas_export_schema]{export_schema} \tab Export schema\cr
\link[=schemas_get_code_binding_source]{get_code_binding_source} \tab Get the code binding source URI\cr
\link[=schemas_get_discovered_schema]{get_discovered_schema} \tab Get the discovered schema that was generated based on sampled events\cr
\link[=schemas_get_resource_policy]{get_resource_policy} \tab Retrieves the resource-based policy attached to a given registry\cr
\link[=schemas_list_discoverers]{list_discoverers} \tab List the discoverers\cr
\link[=schemas_list_registries]{list_registries} \tab List the registries\cr
\link[=schemas_list_schemas]{list_schemas} \tab List the schemas\cr
\link[=schemas_list_schema_versions]{list_schema_versions} \tab Provides a list of the schema versions and related information\cr
\link[=schemas_list_tags_for_resource]{list_tags_for_resource} \tab Get tags for resource\cr
\link[=schemas_put_code_binding]{put_code_binding} \tab Put code binding URI\cr
\link[=schemas_put_resource_policy]{put_resource_policy} \tab The name of the policy\cr
\link[=schemas_search_schemas]{search_schemas} \tab Search the schemas\cr
\link[=schemas_start_discoverer]{start_discoverer} \tab Starts the discoverer\cr
\link[=schemas_stop_discoverer]{stop_discoverer} \tab Stops the discoverer\cr
\link[=schemas_tag_resource]{tag_resource} \tab Add tags to a resource\cr
\link[=schemas_untag_resource]{untag_resource} \tab Removes tags from a resource\cr
\link[=schemas_update_discoverer]{update_discoverer} \tab Updates the discoverer\cr
\link[=schemas_update_registry]{update_registry} \tab Updates a registry\cr
\link[=schemas_update_schema]{update_schema} \tab Updates the schema definition
}
}

\examples{
\dontrun{
svc <- schemas()
svc$create_discoverer(
  Foo = 123
)
}

}
