% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_partitions}
\alias{glue_get_partitions}
\title{Retrieves information about the partitions in a table}
\usage{
glue_get_partitions(
  CatalogId = NULL,
  DatabaseName,
  TableName,
  Expression = NULL,
  NextToken = NULL,
  Segment = NULL,
  MaxResults = NULL,
  ExcludeColumnSchema = NULL,
  TransactionId = NULL,
  QueryAsOfTime = NULL
)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the partitions in question reside. If
none is provided, the Amazon Web Services account ID is used by default.}

\item{DatabaseName}{[required] The name of the catalog database where the partitions reside.}

\item{TableName}{[required] The name of the partitions' table.}

\item{Expression}{An expression that filters the partitions to be returned.

The expression uses SQL syntax similar to the SQL \code{WHERE} filter clause.
The SQL statement parser
\href{https://jsqlparser.sourceforge.net/home.php}{JSQLParser} parses the
expression.

\emph{Operators}: The following are the operators that you can use in the
\code{Expression} API call:

\strong{=}

Checks whether the values of the two operands are equal; if yes, then
the condition becomes true.

Example: Assume 'variable a' holds 10 and 'variable b' holds 20.

(a = b) is not true.

\strong{\< \>}

Checks whether the values of two operands are equal; if the values are
not equal, then the condition becomes true.

Example: (a \< \> b) is true.

\strong{\>}

Checks whether the value of the left operand is greater than the value
of the right operand; if yes, then the condition becomes true.

Example: (a \> b) is not true.

\strong{\<}

Checks whether the value of the left operand is less than the value of
the right operand; if yes, then the condition becomes true.

Example: (a \< b) is true.

\strong{\>=}

Checks whether the value of the left operand is greater than or equal to
the value of the right operand; if yes, then the condition becomes true.

Example: (a \>= b) is not true.

\strong{\<=}

Checks whether the value of the left operand is less than or equal to
the value of the right operand; if yes, then the condition becomes true.

Example: (a \<= b) is true.

\strong{AND, OR, IN, BETWEEN, LIKE, NOT, IS NULL}

Logical operators.

\emph{Supported Partition Key Types}: The following are the supported
partition keys.
\itemize{
\item \code{string}
\item \code{date}
\item \code{timestamp}
\item \code{int}
\item \code{bigint}
\item \code{long}
\item \code{tinyint}
\item \code{smallint}
\item \code{decimal}
}

If an type is encountered that is not valid, an exception is thrown.

The following list shows the valid operators on each type. When you
define a crawler, the \code{partitionKey} type is created as a \code{STRING}, to
be compatible with the catalog partitions.

\emph{Sample API Call}:}

\item{NextToken}{A continuation token, if this is not the first call to retrieve these
partitions.}

\item{Segment}{The segment of the table's partitions to scan in this request.}

\item{MaxResults}{The maximum number of partitions to return in a single response.}

\item{ExcludeColumnSchema}{When true, specifies not returning the partition column schema. Useful
when you are interested only in other partition attributes such as
partition values or location. This approach avoids the problem of a
large response by not returning duplicate data.}

\item{TransactionId}{The transaction ID at which to read the partition contents.}

\item{QueryAsOfTime}{The time as of when to read the partition contents. If not set, the most
recent transaction commit time will be used. Cannot be specified along
with \code{TransactionId}.}
}
\description{
Retrieves information about the partitions in a table.

See \url{https://www.paws-r-sdk.com/docs/glue_get_partitions/} for full documentation.
}
\keyword{internal}
