% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_search_user_profiles}
\alias{datazone_search_user_profiles}
\title{Searches user profiles in Amazon DataZone}
\usage{
datazone_search_user_profiles(
  domainIdentifier,
  maxResults = NULL,
  nextToken = NULL,
  searchText = NULL,
  userType
)
}
\arguments{
\item{domainIdentifier}{[required] The identifier of the Amazon DataZone domain in which you want to search
user profiles.}

\item{maxResults}{The maximum number of results to return in a single call to
\code{\link[=datazone_search_user_profiles]{search_user_profiles}}. When the number
of results to be listed is greater than the value of \code{MaxResults}, the
response contains a \code{NextToken} value that you can use in a subsequent
call to \code{\link[=datazone_search_user_profiles]{search_user_profiles}} to list
the next set of results.}

\item{nextToken}{When the number of results is greater than the default value for the
\code{MaxResults} parameter, or if you explicitly specify a value for
\code{MaxResults} that is less than the number of results, the response
includes a pagination token named \code{NextToken}. You can specify this
\code{NextToken} value in a subsequent call to
\code{\link[=datazone_search_user_profiles]{search_user_profiles}} to list the next
set of results.}

\item{searchText}{Specifies the text for which to search.}

\item{userType}{[required] Specifies the user type for the
\code{\link[=datazone_search_user_profiles]{search_user_profiles}} action.}
}
\description{
Searches user profiles in Amazon DataZone.

See \url{https://www.paws-r-sdk.com/docs/datazone_search_user_profiles/} for full documentation.
}
\keyword{internal}
