% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_list_asset_filters}
\alias{datazone_list_asset_filters}
\title{Lists asset filters}
\usage{
datazone_list_asset_filters(
  assetIdentifier,
  domainIdentifier,
  maxResults = NULL,
  nextToken = NULL,
  status = NULL
)
}
\arguments{
\item{assetIdentifier}{[required] The ID of the data asset.}

\item{domainIdentifier}{[required] The ID of the domain where you want to list asset filters.}

\item{maxResults}{The maximum number of asset filters to return in a single call to
\code{\link[=datazone_list_asset_filters]{list_asset_filters}}. When the number of
asset filters to be listed is greater than the value of \code{MaxResults},
the response contains a \code{NextToken} value that you can use in a
subsequent call to \code{\link[=datazone_list_asset_filters]{list_asset_filters}}
to list the next set of asset filters.}

\item{nextToken}{When the number of asset filters is greater than the default value for
the \code{MaxResults} parameter, or if you explicitly specify a value for
\code{MaxResults} that is less than the number of asset filters, the response
includes a pagination token named \code{NextToken}. You can specify this
\code{NextToken} value in a subsequent call to
\code{\link[=datazone_list_asset_filters]{list_asset_filters}} to list the next set
of asset filters.}

\item{status}{The status of the asset filter.}
}
\description{
Lists asset filters.

See \url{https://www.paws-r-sdk.com/docs/datazone_list_asset_filters/} for full documentation.
}
\keyword{internal}
