\name{MVPIAR-class}
 \docType{class}
  \alias{MVPIAR-class}
  \title{MVPIAR Class}

  \description{This class contains the matrices for the multivariate representation of an object of
    class \code{\link{fit.piartsm-class}}.
  }

  \section{Slots}{
    \describe{
      \item{\code{Phi0}:}{Object of class \code{"matrix"}: Matrix for the multivariate representation. See
        details in \code{\link{PAR.MVrepr-methods}}.}
      \item{\code{Phi1}:}{Object of class \code{"matrix"}: Matrix for the multivariate representation. See
        details in \code{\link{PAR.MVrepr-methods}}.}
      \item{\code{Gamma.eigenvalues}:}{Object of class \code{"numeric"}: Eigenvalues of the matrix
        \eqn{Phi0^{-1} \%*\% Phi1}.}
      \item{\code{tvias}:}{Object of class \code{"matrix"}: Time-varying impact of accumulation of shocks
        calculated as \eqn{Phi0^{-1} \%*\% Phi1 \%*\% Phi0^{-1}}.}
      \item{\code{Omega0}:}{Object of class \code{"ANY"}: Matrix for internal use.}
      \item{\code{Omega1}:}{Object of class \code{"ANY"}: Matrix for internal use.}
      \item{\code{Pi0}:}{Object of class \code{"ANY"}: Matrix for internal use.}
      \item{\code{Pi1}:}{Object of class \code{"ANY"}: Matrix for internal use.}
    }
  }

  \section{Methods}{
    \describe{
      \item{show}{\code{signature(object = "MVPIAR")}: Shows the information contained in the slots.}
    }
  }

  \references{
    P.H. Franses: Periodicity and Stochastic Trends in Economic Time Series (Oxford University Press, 1996).
  }

  \author{Javier Lopez-de-Lacalle \email{javlacalle@yahoo.es}.}

  \seealso{
    \code{\link{PAR.MVrepr-methods}}, and \code{\link{fit.piartsm-class}}.
  }

\keyword{classes}
