% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nullmodel.R
\name{null_model}
\alias{null_model}
\title{Null model}
\usage{
null_model(mode = "classification", engine = "parsnip")
}
\arguments{
\item{mode}{A single character string for the type of model. The only
possible values for this model are \code{"regression"} and \code{"classification"}.}

\item{engine}{A single character string specifying what computational engine
to use for fitting. Possible engines are listed below. The default for this
model is \code{"parsnip"}.}
}
\description{
Fit a single mean or largest class model. \code{null_model()} is the user-facing
function that relies on the underlying computational function, \code{nullmodel()}.
}
\details{
\code{null_model()} defines a simple, non-informative model. It doesn't have any
main arguments. This function can fit classification and regression models.

\code{null_model()} emulates other model building functions, but returns the
simplest model possible given a training set: a single mean for numeric
outcomes and the most prevalent class for factor outcomes. When class
probabilities are requested, the percentage of the training set samples with
the most prevalent class is returned.
}
\section{Engine Details}{
Engines may have pre-set default arguments when executing the model fit
call. For this type of model, the template of the fit calls are below:
\subsection{parsnip}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{null_model() |> 
  set_engine("parsnip") |> 
  set_mode("regression") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Null Model Specification (regression)
## 
## Computational engine: parsnip 
## 
## Model fit template:
## parsnip::nullmodel(x = missing_arg(), y = missing_arg())
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{null_model() |> 
  set_engine("parsnip") |> 
  set_mode("classification") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Null Model Specification (classification)
## 
## Computational engine: parsnip 
## 
## Model fit template:
## parsnip::nullmodel(x = missing_arg(), y = missing_arg())
}\if{html}{\out{</div>}}
}

\subsection{Prediction types}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{parsnip:::get_from_env("null_model_predict") |>
  dplyr::select(mode, type)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 5 x 2
##   mode           type   
##   <chr>          <chr>  
## 1 regression     numeric
## 2 regression     raw    
## 3 classification class  
## 4 classification prob   
## 5 classification raw
}\if{html}{\out{</div>}}
}
}

\examples{
\dontshow{if (!parsnip:::is_cran_check()) withAutoprint(\{ # examplesIf}
null_model(mode = "regression")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=fit.model_spec]{fit.model_spec()}}
}
