% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmd_shortcode_utils.R
\name{shortcode_utils}
\alias{shortcode_utils}
\alias{rmd_has_shortcode}
\alias{rmd_extract_shortcodes}
\title{Shortcode detection and extraction utilities}
\usage{
rmd_has_shortcode(x, func_name = NULL)

rmd_extract_shortcodes(x, flatten = FALSE)
}
\arguments{
\item{x}{An AST node, list of nodes, or character vector}

\item{func_name}{character vector, optional glob patterns for matching shortcode function names.
If NULL (default), matches any shortcode.}

\item{flatten}{Return a flat list shortcodes if \code{TRUE}}
}
\value{
\itemize{
\item \code{rmd_has_shortcode()}: logical vector indicating which nodes contain shortcodes
\item \code{rmd_extract_shortcodes()}: list of shortcode objects found in the content
}
}
\description{
Functions for detecting and extracting shortcodes from AST nodes
after the initial parsing phase.
}
