% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_coefs.R
\name{compare_coefs}
\alias{compare_coefs}
\title{Compare shared coefficients across models}
\usage{
compare_coefs(model_list, padj = "none")
}
\arguments{
\item{model_list}{A list of regression models.}

\item{padj}{A method from \code{p.adjust.methods} for adjusting coefficient
p-values for multiple testing.}
}
\value{
Data frame of shared coefficients, the difference between them, the
 standard error of the difference, the test statistic comparing them, and the
 p-value adjusted using the method provided in \code{padj}.
}
\description{
Compares predictor coefficients across models.
}
\details{
This function currently supports comparing coefficients from two models. For
each model predictor, coefficients are compared across models. P-values come
from a two-sided alternative hypothesis. They can, and should, be adjusted for
multiple testing to reduce the probability of chance significant findings.
}
\examples{
 ##Simulate data

 N = 500

 m = rep(1:2, each=N)

 x1 = rnorm(n=N*2)
 x2 = rnorm(n=N*2)
 x3 = rnorm(n=N*2)

 y = x1 + x2 + x3 + rnorm(n=N*2)

 dat = data.frame(m, x1, x2, x3, y)

 m1 = lm(y ~ x1 + x2 + x3, data=dat, subset=m==1)
 m2 = lm(y ~ x1 + x2 + x3, data=dat, subset=m==2)

 mList = list(m1, m2)

 compare_coefs(model_list = mList, padj='fdr')

}
