% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_replicate.R
\name{ps_replicate}
\alias{ps_replicate}
\title{Create a ParamSet by Repeating a Given ParamSet}
\usage{
ps_replicate(
  set,
  times = length(prefixes),
  prefixes = sprintf("rep\%s", seq_len(times)),
  tag_sets = FALSE,
  tag_params = FALSE
)
}
\arguments{
\item{set}{(\code{\link{ParamSet}})\cr
\code{\link{ParamSet}} to use as template.}

\item{times}{(\code{integer(1)})\cr
Number of times to repeat \code{set}.
Should not be given if \code{prefixes} is provided.}

\item{prefixes}{(\code{character})\cr
A \code{character} vector indicating the prefixes to use for each repetition of \code{set}.
If this is given, \code{times} is inferred from \code{length(prefixes)} and should not be given separately.
If \code{times} is given, this defaults to \code{"repX"}, with \code{X} counting up from 1.}

\item{tag_sets}{(\code{logical(1)})\cr
Whether to add a tag of the form \code{"set_<prefixes[[i]]>"} to each parameter in the result, indicating the repetition each parameter belongs to.}

\item{tag_params}{(\code{logical(1)})\cr
Whether to add a tag of the form \code{"param_<id>"} to each parameter in the result, indicating the original parameter ID inside \code{set}.}
}
\description{
Repeat a \code{\link{ParamSet}} a given number of times and thus create a larger \code{\link{ParamSet}}.
By default, the resulting parameters are prefixed with the string \verb{"repX.", where }X\verb{counts up from 1. It is also possible to tag parameters by their original name and by their prefix, making grouped retrieval e.g. using}$get_values()` easier.
}
\examples{
pset = ps(
  i = p_int(),
  z = p_lgl()
)

ps_replicate(pset, 3)

ps_replicate(pset, prefixes = c("first", "last"))

pset$values = list(i = 1, z = FALSE)

psr = ps_replicate(pset, 2, tag_sets = TRUE, tag_params = TRUE)

# observe the effect of tag_sets, tag_params:
psr$tags

# note that values are repeated as well
psr$values

psr$set_values(rep1.i = 10, rep2.z = TRUE)
psr$values

# use `any_tags` to get subset of values.
# `any_tags = ` is preferable to `tags = `, since parameters
# could also have other tags. `tags = ` would require the
# selected params to have the given tags exclusively.

# get all values associated with the original parameter `i`
psr$get_values(any_tags = "param_i")

# get all values associated with the first repetition "rep1"
psr$get_values(any_tags = "set_rep1")
}
