% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UserApiConsumer.R
\name{UserApiConsumer}
\alias{UserApiConsumer}
\title{UserApiConsumer}
\description{
This class is an opinionated interface around the developer API of the
\code{\link{parabar}} package. See the \strong{Details} section for more
information on how this class works.
}
\details{
This class acts as a wrapper around the \code{\link[R6:R6Class]{R6::R6}} developer API of the
\code{\link{parabar}} package. In a nutshell, it provides an opinionated
interface by wrapping the developer API in simple functional calls. More
specifically, for executing a task in parallel, this class performs the
following steps:
\itemize{
\item Validates the backend provided.
\item Instantiates an appropriate \code{\link{parabar}} context based on the
backend. If the backend supports progress tracking (i.e., the backend is an
instance of \code{\link{AsyncBackend}}), a progress tracking context (i.e.,
\code{\link{ProgressTrackingContext}}) is instantiated and used. Otherwise,
a regular context (i.e., \code{\link{Context}}) is instantiated. A regular
context is also used if the progress tracking is disabled via the
\code{\link{Options}} instance.
\item Registers the \code{\link[=Backend]{backend}} with the context.
\item Instantiates and configures the progress bar based on the
\code{\link{Options}} instance in the session \code{\link[base:options]{base::.Options}} list.
\item Executes the task in parallel, and displays a progress bar if appropriate.
\item Fetches the results from the backend and returns them.
}
}
\examples{
# Define a simple task.
task <- function(x) {
    # Perform computations.
    Sys.sleep(0.01)

    # Return the result.
    return(x + 1)
}

# Start an asynchronous backend.
backend <- start_backend(cores = 2, cluster_type = "psock", backend_type = "async")

# Change the progress bar options.
configure_bar(type = "modern", format = "[:bar] :percent")

# Create an user API consumer.
consumer <- UserApiConsumer$new()

# Execute the task using the `sapply` parallel operation.
output_sapply <- consumer$sapply(backend = backend, x = 1:200, fun = task)

# Print the head of the `sapply` operation output.
head(output_sapply)

# Execute the task using the `sapply` parallel operation.
output_lapply <- consumer$lapply(backend = backend, x = 1:200, fun = task)

# Print the head of the `lapply` operation output.
head(output_lapply)

# Stop the backend.
stop_backend(backend)

}
\seealso{
\code{\link[=start_backend]{start_backend()}}, \code{\link[=stop_backend]{stop_backend()}},
\code{\link[=configure_bar]{configure_bar()}}, \code{\link[=par_sapply]{par_sapply()}}, and
\code{\link[=par_lapply]{par_lapply()}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-UserApiConsumer-sapply}{\code{UserApiConsumer$sapply()}}
\item \href{#method-UserApiConsumer-lapply}{\code{UserApiConsumer$lapply()}}
\item \href{#method-UserApiConsumer-apply}{\code{UserApiConsumer$apply()}}
\item \href{#method-UserApiConsumer-clone}{\code{UserApiConsumer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserApiConsumer-sapply"></a>}}
\if{latex}{\out{\hypertarget{method-UserApiConsumer-sapply}{}}}
\subsection{Method \code{sapply()}}{
Execute a task in parallel akin to \code{\link[parallel:clusterApply]{parallel::parSapply()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserApiConsumer$sapply(backend, x, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{backend}}{An object of class \code{\link{Backend}} as returned by
the \code{\link[=start_backend]{start_backend()}} function. It can also be \code{NULL} to run
the task sequentially via \code{\link[base:lapply]{base::sapply()}}.}

\item{\code{x}}{An atomic vector or list to pass to the \code{fun} function.}

\item{\code{fun}}{A function to apply to each element of \code{x}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector of the same length as \code{x} containing the results of the
\code{fun}. The output format resembles that of \code{\link[base:lapply]{base::sapply()}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserApiConsumer-lapply"></a>}}
\if{latex}{\out{\hypertarget{method-UserApiConsumer-lapply}{}}}
\subsection{Method \code{lapply()}}{
Execute a task in parallel akin to \code{\link[parallel:clusterApply]{parallel::parLapply()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserApiConsumer$lapply(backend, x, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{backend}}{An object of class \code{\link{Backend}} as returned by
the \code{\link[=start_backend]{start_backend()}} function. It can also be \code{NULL} to run
the task sequentially via \code{\link[base:lapply]{base::lapply()}}.}

\item{\code{x}}{An atomic vector or list to pass to the \code{fun} function.}

\item{\code{fun}}{A function to apply to each element of \code{x}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of the same length as \code{x} containing the results of the \code{fun}.
The output format resembles that of \code{\link[base:lapply]{base::lapply()}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserApiConsumer-apply"></a>}}
\if{latex}{\out{\hypertarget{method-UserApiConsumer-apply}{}}}
\subsection{Method \code{apply()}}{
Execute a task in parallel akin to \code{\link[parallel:clusterApply]{parallel::parApply()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserApiConsumer$apply(backend, x, margin, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{backend}}{An object of class \code{\link{Backend}} as returned by
the \code{\link[=start_backend]{start_backend()}} function. It can also be \code{NULL} to run
the task sequentially via \code{\link[base:apply]{base::apply()}}.}

\item{\code{x}}{An array to pass to the \code{fun} function.}

\item{\code{margin}}{A numeric vector indicating the dimensions of \code{x} the
\code{fun} function should be applied over. For example, for a matrix,
\code{margin = 1} indicates applying \code{fun} rows-wise, \code{margin = 2}
indicates applying \code{fun} columns-wise, and \code{margin = c(1, 2)}
indicates applying \code{fun} element-wise. Named dimensions are also
possible depending on \code{x}. See \code{\link[parallel:clusterApply]{parallel::parApply()}} and
\code{\link[base:apply]{base::apply()}} for more details.}

\item{\code{fun}}{A function to apply to \code{x} according to the \code{margin}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The dimensions of the output vary according to the \code{margin} argument.
Consult the documentation of \code{\link[base:apply]{base::apply()}} for a detailed
explanation on how the output is structured.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UserApiConsumer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-UserApiConsumer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UserApiConsumer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
