% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr_utils.R
\name{set_cache_folder}
\alias{set_cache_folder}
\title{Set cache folder for HuggingFace transformers}
\usage{
set_cache_folder(path = NULL)
}
\arguments{
\item{path}{Character string, the path to set as the cache directory.
If NULL, the function will look for the cache directory in a
number of environment variables. Default is NULL.}
}
\value{
Nothing is returned, this function is called for its side effect of
setting the \code{HF_HOME} environment variable, or providing
information to the user.
}
\description{
This function sets the cache directory for HuggingFace transformers. If a
path is given, the function checks if the directory exists and then sets the
\code{HF_HOME} environment variable to this path.
If no path is provided, the function checks for the existing cache directory
in a number of environment variables.
If none of these environment variables are set, it provides the user with
information on the default cache directory.
}
\examples{
\dontshow{if (installed_py_pangoling()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
set_cache_folder("~/new_cache_dir")
}
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://huggingface.co/docs/transformers/installation?highlight=transformers_cache#cache-setup}{Installation docs}

Other helper functions: 
\code{\link{install_py_pangoling}()},
\code{\link{installed_py_pangoling}()}
}
\concept{helper functions}
