% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pangoling-package.R
\docType{package}
\name{pangoling-package}
\alias{pangoling}
\alias{pangoling-package}
\title{pangoling: Access to Large Language Model Predictions}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Provides access to word predictability estimates using large language models (LLMs) based on 'transformer' architectures via integration with the 'Hugging Face' ecosystem \url{https://huggingface.co/}. The package interfaces with pre-trained neural networks and supports both causal/auto-regressive LLMs (e.g., 'GPT-2') and masked/bidirectional LLMs (e.g., 'BERT') to compute the probability of words, phrases, or tokens given their linguistic context. For details on GPT-2 and causal models, see Radford et al. (2019) \url{https://storage.prod.researchhub.com/uploads/papers/2020/06/01/language-models.pdf}, for details on BERT and masked models, see Devlin et al. (2019) \doi{10.48550/arXiv.1810.04805}. By enabling a straightforward estimation of word predictability, the package facilitates research in psycholinguistics, computational linguistics, and natural language processing (NLP).
}
\details{
These options are used to control various aspects of the pangoling package.
Users can customize these options via the \code{options()} function by specifying
\verb{pangoling.<option>} names.
\itemize{
\item \code{pangoling.debug}: Logical; when \code{TRUE}, enables debugging mode. Default is
\code{FALSE}.
\item \code{pangoling.verbose}: Integer; controls the verbosity level (e.g., 0 =
silent, 1 = minimal, 2 = detailed). Default is \code{2}.
\item \code{pangoling.log.p}: Logical; if \code{TRUE} (default), pangoling outputs
log-transformed probabilities with base e, if FALSE the output are raw
probabilities. Alternatively \code{log.p} can be the base of other logarithmic
transformations (e.g., base \code{1/2}, to get surprisal values in bits rather
than predictability).
\item \code{pangoling.cache}: A cache object created with \code{cachem::cache_mem},
allowing you to specify the maximum size (in bytes) for cached objects.
Default is \code{1024 * 1024^2} bytes (1 MB).
\item \code{pangoling.causal.default}: Character string; specifies the default model
for causal language processing. Default is \code{"gpt2"}.
\item \code{pangoling.masked.default}: Character string; specifies the default model
for masked language processing. Default is \code{"bert-base-uncased"}.
}

Use \verb{options(pangoling.<option> = <value>)} to set these options in your
session.
}
\examples{
options(pangoling.verbose = FALSE) # Removes messages
options(pangoling.verbose = TRUE) # Show messages 
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/pangoling/}
  \item \url{https://github.com/ropensci/pangoling}
  \item Report bugs at \url{https://github.com/ropensci/pangoling/issues}
}

}
\author{
\strong{Maintainer}: Bruno Nicenboim \email{b.nicenboim@tilburguniversity.edu} (\href{https://orcid.org/0000-0002-5176-3943}{ORCID})

Other contributors:
\itemize{
  \item Chris Emmerly [contributor]
  \item Giovanni Cassani [contributor]
  \item Lisa Levinson [reviewer]
  \item Utku Turk [reviewer]
}

}
\keyword{internal}
