% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr_causal.R
\name{causal_pred_mats}
\alias{causal_pred_mats}
\title{Generate a list of predictability matrices using a causal transformer model}
\usage{
causal_pred_mats(
  x,
  by = rep(1, length(x)),
  sep = " ",
  log.p = getOption("pangoling.log.p"),
  sorted = FALSE,
  model = getOption("pangoling.causal.default"),
  checkpoint = NULL,
  add_special_tokens = NULL,
  decode = FALSE,
  config_model = NULL,
  config_tokenizer = NULL,
  batch_size = 1,
  ...
)
}
\arguments{
\item{x}{A character vector of words, phrases, or texts to evaluate.}

\item{by}{A grouping variable indicating how texts are split into groups.}

\item{sep}{A string specifying how words are separated within contexts or
groups. Default is \code{" "}. For languages that don't have spaces
between words (e.g., Chinese), set \code{sep = ""}.}

\item{log.p}{Base of the logarithm used for the output predictability values.
If \code{TRUE} (default), the natural logarithm (base \emph{e}) is used.
If \code{FALSE}, the raw probabilities are returned.
Alternatively, \code{log.p} can be set to a numeric value specifying
the base of the logarithm (e.g., \code{2} for base-2 logarithms).
To get surprisal in bits (rather than predictability), set
\code{log.p = 1/2}.}

\item{sorted}{When default FALSE it will retain the order of groups we are
splitting by. When TRUE then sorted (according to \code{by}) list(s)
are returned.}

\item{model}{Name of a pre-trained model or folder. One should be able to use
models based on "gpt2". See
\href{https://huggingface.co/models?other=gpt2}{hugging face website}.}

\item{checkpoint}{Folder of a checkpoint.}

\item{add_special_tokens}{Whether to include special tokens. It has the
same default as the
\href{https://huggingface.co/docs/transformers/v4.25.1/en/model_doc/auto#transformers.AutoTokenizer}{AutoTokenizer}
method in Python.}

\item{decode}{Logical. If \code{TRUE}, decodes the tokens into human-readable
strings, handling special characters and diacritics. Default is
\code{FALSE}.}

\item{config_model}{List with other arguments that control how the
model from Hugging Face is accessed.}

\item{config_tokenizer}{List with other arguments that control how the
tokenizer from Hugging Face is accessed.}

\item{batch_size}{Maximum number of sentences/texts processed in parallel.
Larger batches increase speed but use more memory. Since
all texts in a batch must have the same length, shorter
ones are padded with placeholder tokens.}

\item{...}{Currently not in use.}
}
\value{
A list of matrices with tokens in their columns and the vocabulary of
the model in their rows
}
\description{
This function computes a list of matrices, where each matrix corresponds to a
unique group specified by the \code{by} argument. Each matrix represents the
predictability of every token in the input text (\code{x}) based on preceding
context, as evaluated by a causal transformer model.
}
\details{
The function splits the input \code{x} into groups specified by the \code{by} argument
and processes each group independently. For each group, the model computes
the predictability of each token in its vocabulary based on preceding
context.

Each matrix contains:
\itemize{
\item Rows representing the model's vocabulary.
\item Columns corresponding to tokens in the group (e.g., a sentence or
paragraph).
\item By default, values in the matrices are the natural logarithm of word
probabilities.
}
}
\section{More details about causal models}{

A causal language model (also called GPT-like, auto-regressive, or decoder
model) is a type of large language model usually used for text-generation
that can predict the next word (or more accurately in fact token) based
on a preceding context.

If not specified, the causal model used will be the one set in the global
option \code{pangoling.causal.default}, this can be
accessed via \code{getOption("pangoling.causal.default")} (by default
"gpt2"). To change the default option
use \code{options(pangoling.causal.default = "newcausalmodel")}.

A list of possible causal models can be found in
\href{https://huggingface.co/models?pipeline_tag=text-generation}{Hugging Face website}.

Using the  \code{config_model} and \code{config_tokenizer} arguments, it's possible to
control how the model and tokenizer from Hugging Face is accessed, see the
Python method
\href{https://huggingface.co/docs/transformers/v4.25.1/en/model_doc/auto#transformers.AutoProcessor.from_pretrained}{\code{from_pretrained}}
for details.

In case of errors when a new model is run, check the status of
\url{https://status.huggingface.co/}
}

\examples{
\dontshow{if (installed_py_pangoling()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data("df_sent")
df_sent
list_of_mats <- causal_pred_mats(
                       x = df_sent$word,
                       by = df_sent$sent_n,  
                       model = "gpt2"
                )

# View the structure of the resulting list
list_of_mats |> str()

# Inspect the last rows of the first matrix
list_of_mats[[1]] |> tail()

# Inspect the last rows of the second matrix
list_of_mats[[2]] |> tail()
\dontshow{\}) # examplesIf}
}
\seealso{
Other causal model functions: 
\code{\link{causal_next_tokens_pred_tbl}()},
\code{\link{causal_words_pred}()}
}
\concept{causal model functions}
