% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummify_panel.R
\name{panel_dummify}
\alias{panel_dummify}
\title{Tidy time/variable dummies for panel data}
\usage{
panel_dummify(data, cross.section = NULL, time.variable = NULL)
}
\arguments{
\item{data}{The panel to dummify}

\item{cross.section}{The cross section variable in the panel. Defaults to NULL.}

\item{time.variable}{The variable to indicate time in your panel. Defaults to NULL.}
}
\value{
A new data.table, with the original variables to dummify removed, and new dummy columns included.
}
\description{
A simple function to dummify cross sections or time variables in panel data.
}
\details{
The encoding is binary, whether this is more appropriate than using a factor variable is up to the user.
}
\examples{

x_1 <- rnorm( 10 )
cross_levels <- c( "AT", "DE" )
time <- seq(1:5)
time <- rep(time, 2)
geo_list <- list()
for(i in 1:length(cross_levels))
{
  geo <- rep( cross_levels[i],
                100 )
                  geo_list[[i]] <- geo
                  }
                  geo <- unlist(geo_list)
                  geo <- as.data.frame(geo)

 example_data <- cbind( time,
                        x_1 )
 example_data <- as.data.frame(example_data)

 example_data <- cbind( geo,
                        example_data)
 names(example_data) <- c("geo", "time", "x_1")

 test_dummies <- panel_dummify( data = example_data,
                                cross.section = "geo",
                                time.variable = "time")





}
