% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_panel.R
\name{panel_diff}
\alias{panel_diff}
\title{Tidy panel differencing}
\usage{
panel_diff(data, cross.section, time.variable = NULL, diff.order = 1,
  lags = 1, variables.selected = NULL, keep.original = FALSE)
}
\arguments{
\item{data}{The data input, anything coercible to a data.table.}

\item{cross.section}{The cross section argument, see examples.}

\item{time.variable}{The variable to indicate time in your panel. Defaults to NULL, though it is recommended to have a time variable.}

\item{diff.order}{The number of applications of the difference operator to use in panel differencing. Defaults to 1.}

\item{lags}{The number of lags to use for differences. Defaults to 1.}

\item{variables.selected}{A variable selection for variables to difference, defaults to NULL and differences ALL variables.}

\item{keep.original}{Whether to keep the original undifferenced data, defaults to FALSE.}
}
\value{
The differenced data.table which contains either only the differenced variables, or also the original variables.
}
\description{
Efficient, tidy panel differencing
}
\details{
Works on a full data.table backend for maximum speed wherever possible.
}
\examples{

X <- matrix(rnorm(4000),800,5)
tim <- seq(1:400)
geo_AT <- rep(c("AT"), length = 400)
geo_NO <- rep(c("NO"), length = 400)
both_vec_1 <- cbind(tim,geo_NO)
both_vec_2 <- cbind(tim,geo_AT)
both <- rbind(both_vec_1,both_vec_2)
names(both[,"geo_NO"]) <- "geo"
X <- cbind(both,X)

panel_diff(data = X,
           cross.section = "geo_NO",
           time.variable = "tim",
           diff.order = 1,
           lags = 1,
           variables.selected = c("V3","V4"),
           keep.original = TRUE)


}
