% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettetown.R
\name{pokepal}
\alias{pokepal}
\title{Get a pokemon palette.}
\usage{
pokepal(pokemon = 1, spread = NULL)
}
\arguments{
\item{pokemon}{An integer or character pokemon name}

\item{spread}{How many, quite distinct, colours should be returned. See details.}
}
\description{
Get a pokemon (R) palette by either giving a pokemon number or name.
}
\details{
If \code{spread} is given an integer, the full palette is 
 clustered into that many groups (ward clustering in HSV space, using
 only hue and downweighted saturation). 
 The most common colour in each cluster is then returned. It is
 hoped this will give a good balance between reflecting the pokemons
 colouring while giving relatively distinct colours.

 A few pokemon have odd names. Argument \code{pokemon} ignores letter case.
 Female and Male Nidoran are named NidoranF and NidoranM respectively.
 Mr. Mime should be either 'Mr. Mime' or 'mr. mime'. The full stop and space
 are needed.
}
\examples{
pal <- pokepal(3)
plot(1:length(pal), col = pal)
}
\seealso{
\code{\link{ichooseyou}}
}

