% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customers.R
\name{paddle_update_customer_business}
\alias{paddle_update_customer_business}
\title{Update a Business for a Customer}
\usage{
paddle_update_customer_business(
  id,
  business_id,
  name = NULL,
  company_number = NULL,
  tax_identifier = NULL,
  status = NULL,
  contacts = NULL,
  custom_data = NULL
)
}
\arguments{
\item{id}{Character. Paddle customer ID (e.g., "ctm_123"). Required.}

\item{business_id}{Character. Paddle business ID (e.g., "biz_456"). Required.}

\item{name}{Character. Updated name of the business. Optional.}

\item{company_number}{Character. Updated company number. Optional.}

\item{tax_identifier}{Character. Numeric VAT/tax ID. Optional.}

\item{status}{Character. Status of the customer (one of `"active"` or `"archived"`). Optional.}

\item{contacts}{List of contact objects (named list with at least `"email"`). Optional.}

\item{custom_data}{Named list of custom metadata. Optional.}
}
\value{
A list containing the updated business entity and metadata.
}
\description{
Updates a business entity linked to a specific customer using the Paddle API.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_update_customer_business(
  id = "ctm_123",
  business_id = "biz_123",
  name = "Acme International"
)
\dontshow{\}) # examplesIf}
}
