% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscriptions.R
\name{paddle_list_subscriptions}
\alias{paddle_list_subscriptions}
\title{List subscriptions}
\usage{
paddle_list_subscriptions(
  id = NULL,
  customer_id = NULL,
  address_id = NULL,
  price_id = NULL,
  status = NULL,
  scheduled_change_action = NULL,
  collection_mode = NULL,
  after = NULL,
  order_by = NULL,
  per_page = NULL
)
}
\arguments{
\item{id, customer_id, address_id, price_id}{Character vectors. Optional filters.}

\item{status}{Character vector. Optional. Must be one of `"active"`, `"cancelled"`, `"past_due"`, `"paused"`, `"trialing"`.}

\item{scheduled_change_action}{Character vector. Optional. Must be one of `"cancel"`, `"pause"`, `"resume"`.}

\item{collection_mode}{Character. Optional. Must be one of `"automatic"`, `"manual"`.}

\item{after}{Character. Optional. Return entities after the specified Paddle ID when working with paginated endpoints.}

\item{order_by}{Character. Optional. Must be in the form "id[ASC]" or "id[DESC]".}

\item{per_page}{Integer. Optional. Max 200, defaults to 50.}
}
\value{
A list with subscription data and pagination metadata.
}
\description{
Retrieves a paginated list of subscriptions from the Paddle API.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_list_subscriptions()
\dontshow{\}) # examplesIf}
}
