% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customers.R
\name{paddle_list_credit_balances}
\alias{paddle_list_credit_balances}
\title{List Credit Balances for a Customer}
\usage{
paddle_list_credit_balances(id, currency_code = NULL)
}
\arguments{
\item{id}{Character. Paddle customer ID (e.g., "ctm_123"). Required.}

\item{currency_code}{Optional character vector of ISO 4217 currency codes to filter results.}
}
\value{
A list of credit balances by currency with available, reserved, and used totals.
}
\description{
Retrieves credit balances across all currencies for a specific customer from the Paddle API.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_list_credit_balances(
  id = "ctm_123",
  currency_code = c("USD", "EUR")
)
\dontshow{\}) # examplesIf}
}
