% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customers.R
\name{paddle_create_customer_address}
\alias{paddle_create_customer_address}
\title{Create an Address for a Customer}
\usage{
paddle_create_customer_address(
  id,
  country_code,
  description = NULL,
  first_line = NULL,
  second_line = NULL,
  city = NULL,
  postal_code = NULL,
  region = NULL,
  custom_data = NULL
)
}
\arguments{
\item{id}{Character. Paddle customer ID (e.g., "ctm_123"). Required.}

\item{country_code}{Character. Two-letter ISO 3166-1 alpha-2 country code. Required.}

\item{description}{Character. Optional description for internal reference.}

\item{first_line}{Character. Optional. First line of address.}

\item{second_line}{Character. Optional. Second line of address.}

\item{city}{Character. Optional. City name.}

\item{postal_code}{Character. Optional. ZIP or postal code. Required for some countries.}

\item{region}{Character. Optional. Region, state, or county.}

\item{custom_data}{Named list. Optional custom metadata.}
}
\value{
A list containing the created address entity and metadata.
}
\description{
Creates a new address for a given customer in the Paddle API.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
result <- paddle_create_customer_address(
  id = "ctm_123",
  country_code = "US",
  city = "New York",
  postal_code = "10001"
)
\dontshow{\}) # examplesIf}
}
