% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prioritise_and_diagnose.R
\name{prioritise_and_diagnose}
\alias{prioritise_and_diagnose}
\alias{prioritize_and_diagnose}
\title{Prioritise and diagnose the loan book data sets used in the PACTA for Supervisors analysis}
\usage{
prioritise_and_diagnose(config)

prioritize_and_diagnose(config)
}
\arguments{
\item{config}{either a path to a config.yml file or a list of parameters}
}
\value{
\code{prioritise_and_diagnose()} returns \code{NULL} invisibly. The function is called
for its side effects and writes the prepared and diagnosed data sets in the
directory specified by \code{dir_prioritized_loanbooks_and_diagnostics} in the
\code{config.yml}.
}
\description{
\code{prioritise_and_diagnose()} runs the necessary steps to prioritise the
matched loan books and diagnose both the match success rate and the coverage
of the real economy assets by the matched loan books. Parameters for all
steps are read from a \code{config.yml} file. The function is called for its side
effects and writes the prepared and diagnosed data sets in the directory
specified by \code{dir_prioritized_loanbooks_and_diagnostics} in the \code{config.yml}.

\code{prioritise_and_diagnose()} and \code{prioritize_and_diagnose()} are synonyms.
}
\examples{
\dontrun{
config <- "path/to/config.yml"
prioritise_and_diagnose(config)
}

}
